package test.org.seasar.framework.aop.impl;

import java.util.Date;

import junit.framework.TestCase;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Joinpoint;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.proxy.AopProxy;

/**
 * @author higa
 *
 */
public class JoinpointImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public JoinpointImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(JoinpointImplTest.class);
	}

	public void testProceed() throws Exception {
		TestAdvice advice = new TestAdvice();
		TestAdvice advice2 = new TestAdvice();
		Pointcut pointcut =
			new PointcutImpl(new String[]{ "getTime" });
		Aspect aspect = new AspectImpl(advice, pointcut);
		Aspect aspect2 = new AspectImpl(advice2, pointcut);
		AopProxy aopProxy =
			new AopProxy(Date.class, new Aspect[] { aspect, aspect2 });
		Date proxy = (Date) aopProxy.create();
		System.out.println(proxy.getTime());
		assertEquals("1", true, advice.invoked_);
		assertEquals("2", true, advice2.invoked_);
	}
	
	public void testProceedForAbstractMethod() throws Exception {
		HogeAdvice advice = new HogeAdvice();
		Aspect aspect = new AspectImpl(advice);
		AopProxy aopProxy =
			new AopProxy(Hoge.class, new Aspect[] { aspect });
		Hoge proxy = (Hoge) aopProxy.create();
		assertEquals("1", "Hello", proxy.foo());
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public class TestAdvice implements AroundAdvice {

		private boolean invoked_ = false;

		public Object invoke(Joinpoint joinpoint) throws Throwable {
			invoked_ = true;
			return joinpoint.proceed();
		}

	}
	
	public interface Hoge {
		public String foo();
	}

	public static class HogeAdvice implements AroundAdvice {

		public Object invoke(Joinpoint joinpoint) throws Throwable {
			return "Hello";
		}

	}
}
