package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.IllegalMethodRuntimeException;
import org.seasar.framework.container.InitMethodDef;

/**
 * @author higa
 *
 */
public class DefaultInitMethodAssembler
	extends AbstractMethodAssembler {

	/**
	 * @param componentDef
	 */
	public DefaultInitMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	public void assemble(Object component)
		throws IllegalMethodRuntimeException {

		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getInitMethodDefSize();
		for (int i = 0; i < size; ++i) {
			InitMethodDef methodDef =
				getComponentDef().getInitMethodDef(i);
			Object[] args = null;
			try {
				args = methodDef.getArgs();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalMethodRuntimeException(
					getComponentDef().getComponentClass(),
					methodDef.getMethodName(),
					cause);
			}
			invoke(beanDesc, component, methodDef.getMethodName(), args);
		}
	}

}
