package test.org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class S2ContainerImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public S2ContainerImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2ContainerImplTest.class);
	}

	public void testRegister() throws Exception {
		S2Container container = new S2ContainerImpl();
		container.register(A.class);
		container.register(B.class);
		container.register(B2.class);
		try {
			container.getComponent(A.class);
			fail("1");
		} catch (TooManyRegistrationRuntimeException ex) {
			System.out.println(ex);
			assertEquals("2", Hoge.class, ex.getKey());
			assertEquals("3", 2, ex.getComponentClasses().length);
			assertEquals("4", B.class, ex.getComponentClasses()[0]);
			assertEquals("5", B2.class, ex.getComponentClasses()[1]);
		}
	}

	public void testRegisterForAlreadRegistration() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDef cd = new ComponentDefImpl(B.class, "B");
		ComponentDef cd2 = new ComponentDefImpl(B2.class, "B");
		container.register(cd);
		container.register(cd2);
		try {
			container.getComponent("B");
			fail("1");
		} catch (TooManyRegistrationRuntimeException ex) {
			System.out.println(ex);
			assertEquals("2", "B", ex.getKey());
			assertEquals("3", 2, ex.getComponentClasses().length);
			assertEquals("4", B.class, ex.getComponentClasses()[0]);
			assertEquals("5", B2.class, ex.getComponentClasses()[1]);
		}
	}

	public void testInclude() throws Exception {
		S2Container container = new S2ContainerImpl();
		container.register(A.class);
		S2Container container2 = new S2ContainerImpl();
		container2.register(B.class);
		container.include(container2);
		A a = (A) container.getComponent(A.class);
		assertEquals("1", "B", a.getHogeName());
	}

	public void testInitAndDestroy() throws Exception {
		S2Container container = new S2ContainerImpl();
		List initList = new ArrayList();
		List destroyList = new ArrayList();
		ComponentDef componentDef = new ComponentDefImpl(C.class, "c1");
		componentDef.addInitMethodDef(new InitMethodDefImpl("init"));
		componentDef.addDestroyMethodDef(new DestroyMethodDefImpl("destroy"));
		componentDef.addArgDef(new ArgDefImpl("c1"));
		componentDef.addArgDef(new ArgDefImpl(initList));
		componentDef.addArgDef(new ArgDefImpl(destroyList));
		container.register(componentDef);

		componentDef = new ComponentDefImpl(C.class, "c2");
		componentDef.addInitMethodDef(new InitMethodDefImpl("init"));
		componentDef.addDestroyMethodDef(new DestroyMethodDefImpl("destroy"));
		componentDef.addArgDef(new ArgDefImpl("c2"));
		componentDef.addArgDef(new ArgDefImpl(initList));
		componentDef.addArgDef(new ArgDefImpl(destroyList));
		container.register(componentDef);

		container.init();
		assertEquals("1", 2, initList.size());
		assertEquals("2", "c1", initList.get(0));
		assertEquals("3", "c2", initList.get(1));
		container.destroy();
		assertEquals("4", 2, destroyList.size());
		assertEquals("5", "c2", destroyList.get(0));
		assertEquals("6", "c1", destroyList.get(1));
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static class A {

		private Hoge hoge_;

		public A(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}

	public static class B2 implements Hoge {

		public String getName() {
			return "B2";
		}
	}

	public static class C {

		private String name_;
		private List initList_;
		private List destroyList_;

		public C(String name, List initList, List destoryList) {
			name_ = name;
			initList_ = initList;
			destroyList_ = destoryList;
		}

		public void init() {
			initList_.add(name_);
		}

		public void destroy() {
			destroyList_.add(name_);
		}
	}
}