package org.seasar.framework.xml.sax.handler;

import java.io.InputStream;

import javax.xml.parsers.SAXParser;

import org.seasar.framework.util.io.ResourceUtil;
import org.seasar.framework.util.sax.SAXParserFactoryUtil;
import org.seasar.framework.util.sax.SAXParserUtil;
import org.xml.sax.InputSource;

public final class SaxHandlerParser {

	private SaxHandler saxHandler_;
	private SAXParser saxParser_;

	public SaxHandlerParser(SaxHandler saxHandler) {
		this(saxHandler, SAXParserFactoryUtil.newSAXParser());
	}

	public SaxHandlerParser(SaxHandler saxHandler, SAXParser saxParser) {
		saxHandler_ = saxHandler;
		saxParser_ = saxParser;
	}

	public Object parse(String path) {
		return parse(ResourceUtil.getResourceAsStream(path, "xml"));
	}

	public Object parse(InputStream inputStream) {
		return parse(new InputSource(inputStream));
	}

	public Object parse(InputSource inputSource) {
		SAXParserUtil.parse(saxParser_, inputSource, saxHandler_);
		return saxHandler_.getResult();
	}
}
