package org.seasar.framework.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.seasar.framework.exception.lang.IllegalAccessRuntimeException;
import org.seasar.framework.exception.lang.InstantiationRuntimeException;
import org.seasar.framework.exception.lang.reflect.InvocationTargetRuntimeException;

/**
 * @author higa
 *
 */
public final class MethodUtil {

	/**
	 * 
	 */
	private MethodUtil() {
	}

	public static Object invoke(Method method, Object target, Object[] args)
		throws InstantiationRuntimeException, IllegalAccessRuntimeException {

		try {
			return method.invoke(target, args);
		} catch (InvocationTargetException ex) {
			throw new InvocationTargetRuntimeException(
				method.getDeclaringClass(),
				ex);
		} catch (IllegalAccessException ex) {
			throw new IllegalAccessRuntimeException(
				method.getDeclaringClass(),
				ex);
		}
	}
}
