package org.seasar.framework.exception.transaction.xa;

import javax.transaction.xa.XAException;

import org.seasar.framework.util.message.MessageFormatter;

/**
 * @author higa
 *
 */
public class SXAException extends XAException {

	private String messageCode_;
	private Object[] messageArgs_;
	
	public SXAException(String messageCode, Object[] messageArgs) {
		super(MessageFormatter.getMessage(messageCode, messageArgs));
		messageCode_ = messageCode;
		messageArgs_ = messageArgs;
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getMessageArgs() {
		return messageArgs_;
	}
}
