package org.seasar.framework.exception.lang;

import org.seasar.framework.util.message.MessageFormatter;

/**
 * @author higa
 *
 */
public final class SIllegalStateException extends IllegalStateException {

	private String messageCode_;
	private Object[] args_;

	public SIllegalStateException(String messageCode, Object[] args) {
		super(MessageFormatter.getMessage(messageCode, args));
		
		messageCode_ = messageCode;
		args_ = args;
	}

	public String getMessageCode() {
		return messageCode_;
	}
	
	public Object[] getArgs() {
		return args_;
	}
}
