package org.seasar.framework.exception.lang;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * NoSuchMethodExceptionbvsOłB
 */
public class NoSuchMethodRuntimeException extends SRuntimeException {

	private Class targetClass_;
	private String methodName_;
	private Class[] argTypes_;

	public NoSuchMethodRuntimeException(
		Class targetClass,
		String methodName,
		Class[] argTypes,
		NoSuchMethodException cause) {

		super(
			"ESSR0057",
			new Object[] { targetClass.getName(),
				getSignature(methodName, argTypes), cause},
			cause);
		targetClass_ = targetClass;
		methodName_ = methodName;
		argTypes_ = argTypes;
	}
	
	public Class getTargetClass() {
		return targetClass_;
	}
	
	public String getMethodName() {
		return methodName_;
	}
	
	public Class[] getArgTypes() {
		return argTypes_;
	}
	
	private static String getSignature(String methodName, Class[] argTypes) {
		StringBuffer buf = new StringBuffer(100);
		buf.append(methodName);
		buf.append("(");
		if (argTypes != null) {
			for (int i = 0; i < argTypes.length; ++i) {
				if (i > 0) {
					buf.append(", ");
				}
				buf.append(argTypes[i].getName());
			}
		}
		buf.append(")");
		return buf.toString();
	}
}
