package org.seasar.framework.container.factory;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.util.reflect.ClassUtil;
import org.seasar.framework.xml.sax.handler.TagHandler;
import org.seasar.framework.xml.sax.handler.TagHandlerContext;
import org.xml.sax.Attributes;

/**
 * @author higa
 *
 */
public class ComponentTagHandler extends TagHandler {

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#start(org.seasar.framework.xml.sax.handler.TagHandlerContext, org.xml.sax.Attributes)
	 */
	public void start(TagHandlerContext context, Attributes attributes) {
		ComponentDef componentDef = null;
		String className = attributes.getValue("class");
		if (className == null) {
			throw new TagAttributeNotDefinedRuntimeException(
				"component",
				"class");
		}
		Class componentClass = ClassUtil.forName(className);
		String name = attributes.getValue("name");
		if (name != null) {
			componentDef = new ComponentDefImpl(componentClass, name);
		} else {
			componentDef = new ComponentDefImpl(componentClass);
		}
		String instanceMode = attributes.getValue("instance");
		if (instanceMode != null) {
			componentDef.setInstanceMode(instanceMode);
		}
		String autoBindingMode = attributes.getValue("autoBinding");
		if (autoBindingMode != null) {
			componentDef.setAutoBindingMode(autoBindingMode);
		}
		context.push(componentDef);
	}

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#end(org.seasar.framework.xml.sax.handler.TagHandlerContext, java.lang.String)
	 */
	public void end(TagHandlerContext context, String body) {
		ComponentDef componentDef = (ComponentDef) context.pop();
		if (context.peek() instanceof S2Container) {
			S2Container container = (S2Container) context.peek();
			container.register(componentDef);
		} else {
			ArgDef argDef = (ArgDef) context.peek();
			argDef.setChildComponentDef(componentDef);
		}
	}

}
