package org.seasar.framework.container.assembler.method;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.IllegalMethodConfigurationRuntimeException;

/**
 * @author higa
 *
 */
public class DefaultDestroyMethodAssembler extends AbstractInitMethodAssembler {

	/**
	 * @param componentDef
	 */
	public DefaultDestroyMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.method.MethodAssembler#assemble(java.lang.Object)
	 */
	public void assemble(Object component)
		throws IllegalMethodConfigurationRuntimeException {

		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getDestroyMethodDefSize();
		for (int i = 0; i < size; ++i) {
			DestroyMethodDef methodDef = getComponentDef().getDestroyMethodDef(i);
			Object[] args = null;
			try {
				args = methodDef.getArgs();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalMethodConfigurationRuntimeException(
					getComponentDef().getComponentClass(),
					methodDef.getMethodName(),
					cause);
			}
			beanDesc.invoke(component, methodDef.getMethodName(), args);
		}
	}

}
