package org.seasar.framework.beans;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * Ώۂ̃NXɓKp\ȃ\bhȂꍇ̎sOłB
 */
public final class MethodNotFoundRuntimeException extends SRuntimeException {

	private Class targetClass_;
	private String methodName_;
	private Object[] methodArgs_;

	/**
	 * @param targetClass
	 */
	public MethodNotFoundRuntimeException(Class targetClass, String methodName,
		Object[] methodArgs) {

		super("ESSR0049", new Object[]{targetClass.getName(),
			getSignature(methodName, methodArgs)});
		targetClass_ = targetClass;
		methodName_ = methodName;
		methodArgs_ = methodArgs;
	}
	
	public Class getTargetClass() {
		return targetClass_;
	}

	public String getMethodName() {
		return methodName_;
	}
	
	public Object[] getMethodArgs() {
		return methodArgs_;
	}
	
	private static String getSignature(String methodName, Object[] methodArgs) {
		StringBuffer buf = new StringBuffer(100);
		buf.append(methodName);
		buf.append("(");
		if (methodArgs != null) {
			for (int i = 0; i < methodArgs.length; ++i) {
				if (i > 0) {
					buf.append(", ");
				}
				if (methodArgs[i] != null) {
					buf.append(methodArgs[i].getClass().getName());
				} else {
					buf.append("null"); 
				}
			}
		}
		buf.append(")");
		return buf.toString();
	}
}
