package test.org.seasar.framework.sel.exps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.util.conversion.DateConversionUtil;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.exps.ToStringExp;

public class ToStringExpTest extends TestCase {

	public ToStringExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		Expression exp = new ToStringExp(new ObjectExp(new Integer(1)), "000");
		assertEquals("1", "001", exp.evaluateValue(null));
	}

	public void testEvaluate2() throws Exception {
		Expression exp =
			new ToStringExp(
				new ObjectExp(
					DateConversionUtil.toDate("20021114", "yyyyMMdd")),
				"yyyy/MM/dd");
		assertEquals("1", "2002/11/14", exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ToStringExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ToStringExpTest.class.getName()});
	}
}