package test.org.seasar.framework.container.factory;

import java.util.List;

import junit.framework.TestCase;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

/**
 * @author higa
 *
 */
public class ComponentTagHandlerTest extends TestCase {

	private static final String PATH =
		"test/org/seasar/framework/container/factory/ComponentTagHandlerTest.xml";
	public ComponentTagHandlerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ComponentTagHandlerTest.class);
	}

	public void testComponent() throws Exception {
		S2Container container = S2ContainerFactory.create(PATH);
		container.init();
		assertNotNull("1", container.getComponent(List.class));
		assertNotNull("2", container.getComponent("aaa"));
		assertEquals("3", new Integer(1), container.getComponent("bbb"));
		Hoge hoge = (Hoge) container.getComponent(Hoge.class);
		assertEquals("4", true, hoge.isInited());
		container.destroy();
		assertEquals("5", true, hoge.isDestroyed());
		assertEquals(
			"6",
			true,
			container.getComponent("ccc") != container.getComponent("ccc"));
		ComponentDef cd =
			container.getComponentDef(container.getComponentDefSize() - 1);
		assertEquals(
			"7",
			ContainerConstants.AUTO_BINDING_NONE,
			cd.getAutoBindingMode());
	}

	public static class Hoge {

		private boolean inited_ = false;
		private boolean destroyed_ = false;

		public boolean isInited() {
			return inited_;
		}

		public boolean isDestroyed() {
			return destroyed_;
		}
		public void init() {
			inited_ = true;
		}

		public void destroy() {
			destroyed_ = true;
		}
	}
}
