package test.org.seasar.framework.container.deployer;

import java.math.BigDecimal;
import java.util.HashMap;

import junit.framework.TestCase;

import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.ComponentDeployer;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.MethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class SingletonComponentDeployerTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public SingletonComponentDeployerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(SingletonComponentDeployerTest.class);
	}

	public void testDeployAutoAutoConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		container.register(B.class);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A a = (A) deployer.deploy();
		assertEquals("1", "B", a.getHogeName());
		assertSame("2", a, deployer.deploy());
	}

	public void testDeployAutoAutoProperty() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A2.class);
		container.register(cd);
		container.register(B.class);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A2 a2 = (A2) deployer.deploy();
		assertEquals("1", "B", a2.getHogeName());
	}

	public void testDeployAutoManualConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(BigDecimal.class);
		cd.addArgDef(new ArgDefImpl("123"));
		container.register(cd);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		assertEquals("1", new BigDecimal(123), deployer.deploy());
	}

	public void testDeployAutoManualProperty() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A2.class);
		cd.addPropertyDef(new PropertyDefImpl("hoge", new B()));
		container.register(cd);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A2 a2 = (A2) deployer.deploy();
		assertEquals("1", "B", a2.getHogeName());
	}

	public void testGetComponentForMethodDef() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
		MethodDef md = new MethodDefImpl("put");
		md.addArgDef(new ArgDefImpl("aaa"));
		md.addArgDef(new ArgDefImpl("hoge"));
		cd.addMethodDef(md);
		container.register(cd);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		HashMap myMap = (HashMap) deployer.deploy();
		assertEquals("1", "hoge", myMap.get("aaa"));
	}

	public void testCyclicReference() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A2.class);
		ComponentDefImpl cd2 = new ComponentDefImpl(C.class);
		container.register(cd);
		container.register(cd2);
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		ComponentDeployer deployer2 = new SingletonComponentDeployer(cd2);
		A2 a2 = (A2) deployer.deploy();
		C c = (C) deployer2.deploy();
		assertEquals("1", "C", a2.getHogeName());
		assertEquals("2", "C", c.getHogeName());
	}
	
	public void testDeployConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		container.register(B.class);
		cd.setAutoBindingMode("constructor");
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A a = (A) deployer.deploy();
		assertEquals("1", "B", a.getHogeName());
	}
	
	public void testDeployProperty() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A2.class);
		container.register(cd);
		container.register(B.class);
		cd.setAutoBindingMode("property");
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A2 a2 = (A2) deployer.deploy();
		assertEquals("1", "B", a2.getHogeName());
	}
	
	public void testDeployNoneManualConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(BigDecimal.class);
		cd.addArgDef(new ArgDefImpl("123"));
		container.register(cd);
		cd.setAutoBindingMode("none");
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		assertEquals("1", new BigDecimal(123), deployer.deploy());
	}
	
	public void testDeployNoneManualProperty() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A2.class);
		cd.addPropertyDef(new PropertyDefImpl("hoge", new B()));
		container.register(cd);
		cd.setAutoBindingMode("none");
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		A2 a2 = (A2) deployer.deploy();
		assertEquals("1", "B", a2.getHogeName());
	}
	
	public void testDeployNoneDefault() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(String.class);
		container.register(cd);
		cd.setAutoBindingMode("none");
		ComponentDeployer deployer = new SingletonComponentDeployer(cd);
		assertEquals("1", "", deployer.deploy());
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public interface Foo {
		public String getHogeName();
	}

	public static class A {

		private Hoge hoge_;

		public A(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public static class A2 implements Foo {

		private Hoge hoge_;

		public void setHoge(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}

	public static class C implements Hoge {

		private Foo foo_;

		public void setFoo(Foo foo) {
			foo_ = foo;
		}

		public String getName() {
			return "C";
		}

		public String getHogeName() {
			return foo_.getHogeName();
		}
	}
}