package test.org.seasar.framework.container.assembler.constructor;

import junit.framework.TestCase;

import org.seasar.framework.aop.advices.TraceAdvice;
import org.seasar.framework.container.S2Container;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.AutoConstructorAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.ConstructorAssembler;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class AutoConstructorAssemblerTest extends TestCase {

	public AutoConstructorAssemblerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AutoConstructorAssemblerTest.class);
	}

	public void testAssemble() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		container.register(B.class);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", "B", a.getHogeName());
	}

	public void testAssembleAspect() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		cd.addAspectDef(new AspectDefImpl(new TraceAdvice()));
		container.register(cd);
		container.register(B.class);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", "B", a.getHogeName());
	}

	public void testAssembleArgNotFound() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		A a = (A) assembler.assemble();
		assertEquals("1", null, a.getHoge());
	}

	public void testAssembleDefaultConstructor() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(String.class);
		container.register(cd);
		ConstructorAssembler assembler = new AutoConstructorAssembler(cd);
		assertEquals("1", "", assembler.assemble());
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public interface Foo {
		public String getHogeName();
	}

	public static class A implements Foo {

		private Hoge hoge_;

		public A(Hoge hoge) {
			hoge_ = hoge;
		}

		public Hoge getHoge() {
			return hoge_;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}
}