package org.seasar.framework.util.message;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author higa
 *
 * bZ[WR[hƈvpeBɓo^Ă
 * p^[ɓKpAbZ[WgݗĂ܂B<br />
 * bZ[WR[h́A8ō\
 * ŏ1bZ[W̎ʂŁAE:G[AW:[jOAI:CtH[Vō\܂B<br />
 * 3VXeSeasaȑꍇ́ASSRɂȂ܂B<br />
 * Ō4́AAԂłB
 */

public final class MessageFormatter {

	/** bZ[Wݒt@C̃ftHg̃pX */
	public static final String DEFAULT_CONFIG_PATH = "message-config";
	/** Seasar̃bZ[Wo^ĂvpeB̃pX */
	private static final String SEASAR_MESSAGES =
		"org.seasar.framework.message.SSRMessages";
	/** Seasar̃TuVXe */
	private static final String SEASAR_SUBSYSTEM = "SSR";
	/** bZ[Wǂ̃vpeBɓo^Ă̂̐ݒt@C̃pX */
	private static String configPath_ = DEFAULT_CONFIG_PATH;
	/** TuVXe(L[)ƂResourceBundle */
	private static Map messagesMap_ = new HashMap();

	static {
		try {
			setup();
		} catch (MissingResourceException ignore) {
		}
		if (messagesMap_.size() == 0) {
			messagesMap_.put(
				SEASAR_SUBSYSTEM,
				ResourceBundle.getBundle(SEASAR_MESSAGES));
		}
	}

	/**
	 * VOĝ߃vCx[g
	 */
	private MessageFormatter() {
	}

	/**
	 * eXgƂɃftHgȊO̐ݒt@CgƂ
	 * ݒ肵܂B
	 * @param configFile ݒt@C̃pX
	 */
	public static void setConfigPath(String configPath) {
		configPath_ = configPath;
	}

	/**
	 * @return ݒt@CResourceBundleԂ܂B
	 */
	public static ResourceBundle getConfig() {
		return ResourceBundle.getBundle(configPath_);
	}

	/**
	 * bZ[WR[h2ڂ4ڂԂ܂B
	 * @param messageCode bZ[WR[h
	 * @return TuVXe
	 */
	public static String getSubSystem(final String messageCode) {
		return messageCode.substring(1, Math.min(4, messageCode.length()));
	}

	/**
	 * @param subSystem
	 * @return TuVXeƂResourceBundleԂ܂B
	 */
	public static ResourceBundle getMessages(final String subSystem) {
		return (ResourceBundle) messagesMap_.get(subSystem);
	}

	/**
	 * @param messageCode
	 * @return bZ[WR[hɉp^[Ԃ܂B<br />
	 * bZ[Wt@CȂ邢́AbZ[WR[ho^ĂȂꍇ́A
	 * nullԂ܂B
	 */
	public static String getPattern(final String messageCode) {
		try {
			ResourceBundle resourceBundle =
				getMessages(getSubSystem(messageCode));
			if (resourceBundle != null) {
				return resourceBundle.getString(messageCode);
			}
		} catch (Exception ignore) {
		}
		return null;
	}

	/**
	 * @param args
	 * @return p^[Ȃꍇ̃bZ[WԂ܂B
	 * @see #getPattern(String)
	 */
	public static String getNoPatternMessage(final Object[] args) {
		if (args == null || args.length == 0) {
			return "";
		}
		StringBuffer buffer = new StringBuffer();
		for (int i = 0; i < args.length; i++) {
			buffer.append(args[i] + ", ");
		}
		buffer.setLength(buffer.length() - 2);
		return buffer.toString();
	}

	/**
	 * @param messageCode
	 * @param arguments
	 * @return bZ[WR[h܂܂ȂbZ[WԂ܂B
	 */
	public static String getSimpleMessage(
		final String messageCode,
		final Object[] arguments) {
		String pattern = getPattern(messageCode);
		if (pattern != null) {
			return MessageFormat.format(pattern, arguments);
		} else {
			return getNoPatternMessage(arguments);
		}
	}

	/**
	 * @param messageCode
	 * @param args
	 * @return bZ[WR[ht̃bZ[WԂ܂B
	 */
	public static String getMessage(String messageCode, Object[] args) {
		if (messageCode == null) {
			messageCode = "";
		}
		return "[" + messageCode + "]" + getSimpleMessage(messageCode, args);
	}

	/**
	 * ݒt@CǂݍŁATuVXeResourceBundle֘At܂B
	 */
	public static void setup() {
		ResourceBundle config = getConfig();
		for (Enumeration e = config.getKeys(); e.hasMoreElements();) {
			String key = (String) e.nextElement();
			String resourceName = config.getString(key);
			messagesMap_.put(key, ResourceBundle.getBundle(resourceName));
		}
	}

	/**
	 * ftHg̐ݒԂɖ߂܂BeXgpłB
	 */
	public static void defaultSetup() {
		configPath_ = DEFAULT_CONFIG_PATH;
		setup();
	}
}