package org.seasar.framework.unit;

import java.lang.reflect.Method;

import org.seasar.framework.exception.lang.NoSuchMethodRuntimeException;
import org.seasar.framework.util.reflect.ClassUtil;
import org.seasar.framework.util.reflect.MethodUtil;

import junit.framework.TestCase;

public class S2TestCase extends TestCase {

	public S2TestCase(String name) {
		super(name);
	}

	public void runBare() throws Throwable {
		setUp();
		try {
			setUpForEachTestMethod();
			try {
				runTest();
			} finally {
				tearDownForEachTestMethod();
			}
		} finally {
			tearDown();
		}
	}

	protected void setUpForEachTestMethod() throws Throwable {
		invoke("setUp" + getName().substring(4));
	}

	protected void tearDownForEachTestMethod() throws Throwable {
		invoke("tearDown" + getName().substring(4));
	}
	
	private void invoke(String methodName) throws Throwable {
		try {
			Method method = ClassUtil.getMethod(
				getClass(), methodName, null);
			MethodUtil.invoke(method, this, null);
		} catch (NoSuchMethodRuntimeException ignore) {
		}
	}
}