package org.seasar.framework.exception.lang;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * NoSuchMethodExceptionbvsOłB
 */
public class NoSuchMethodRuntimeException extends SRuntimeException {

	private Class targetClass_;
	private String methodName_;

	public NoSuchMethodRuntimeException(
		Class targetClass,
		String methodName,
		NoSuchMethodException cause) {

		super(
			"ESSR0057",
			new Object[] { targetClass.getName(), methodName, cause},
			cause);
		targetClass_ = targetClass;
		methodName_ = methodName;
	}
	
	public Class getTargetClass() {
		return targetClass_;
	}
	
	public String getMethodName() {
		return methodName_;
	}
}
