package org.seasar.framework.container.impl;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.ComponentDeployer;
import org.seasar.framework.container.deployer.factory.ComponentDeployerFactory;
import org.seasar.framework.container.util.ArgDefSupport;
import org.seasar.framework.container.util.AspectDefSupport;
import org.seasar.framework.container.util.AutoBindingUtil;
import org.seasar.framework.container.util.InstanceModeUtil;
import org.seasar.framework.container.util.MethodDefSupport;
import org.seasar.framework.container.util.PropertyDefSupport;
import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * @author higa
 *
 */
public final class ComponentDefImpl
	implements ComponentDef, ContainerConstants {

	private Class componentClass_;
	private String componentName_;
	private S2Container container_;
	private Object component_;
	private ArgDefSupport argDefSupport_ = new ArgDefSupport();
	private PropertyDefSupport propertyDefSupport_ = new PropertyDefSupport();
	private MethodDefSupport methodDefSupport_ = new MethodDefSupport();
	private AspectDefSupport aspectDefSupport_ = new AspectDefSupport();
	private String initMethodName_;
	private String destroyMethodName_;
	private String instanceMode_ = INSTANCE_SINGLETON;
	private String autoBindingMode_ = AUTO_BINDING_AUTO;
	private ComponentDeployer componentDeployer_;

	public ComponentDefImpl(Class componentClass)
		throws EmptyRuntimeException {

		this(componentClass, null);
	}

	public ComponentDefImpl(Class componentClass, String componentName)
		throws EmptyRuntimeException {

		if (componentClass == null) {
			throw new EmptyRuntimeException("componentClass");
		}
		componentClass_ = componentClass;
		componentName_ = componentName;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getComponent()
	 */
	public Object getComponent() {
		return getComponentDeployer().deploy();
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getComponentClass()
	 */
	public final Class getComponentClass() {
		return componentClass_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getComponentName()
	 */
	public final String getComponentName() {
		return componentName_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getContainer()
	 */
	public final S2Container getContainer() {
		return container_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#setContainer(org.seasar.framework.container.S2Container)
	 */
	public final void setContainer(S2Container container) {
		container_ = container;
		argDefSupport_.setContainer(container);
		propertyDefSupport_.setContainer(container);
		methodDefSupport_.setContainer(container);
		aspectDefSupport_.setContainer(container);
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#addArgDef(org.seasar.framework.container.ArgDef)
	 */
	public void addArgDef(ArgDef argDef) {
		argDefSupport_.addArgDef(argDef);
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#addPropertyDef(org.seasar.framework.container.PropertyDef)
	 */
	public void addPropertyDef(PropertyDef propertyDef) {
		propertyDefSupport_.addPropertyDef(propertyDef);
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#addMethodDef(org.seasar.framework.container.MethodDef)
	 */
	public void addMethodDef(MethodDef methodDef) {
		methodDefSupport_.addMethodDef(methodDef);
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#addAspectDef(org.seasar.framework.container.AspectDef)
	 */
	public void addAspectDef(AspectDef aspectDef) {
		aspectDefSupport_.addAspectDef(aspectDef);
	}

	/**
	 * @see org.seasar.framework.container.ArgDefAware#getArgDefSize()
	 */
	public int getArgDefSize() {
		return argDefSupport_.getArgDefSize();
	}

	/**
	 * @see org.seasar.framework.container.PropertyDefAware#getPropertyDefSize()
	 */
	public int getPropertyDefSize() {
		return propertyDefSupport_.getPropertyDefSize();
	}

	/**
	 * @see org.seasar.framework.container.MethodDefAware#getMethodDefSize()
	 */
	public int getMethodDefSize() {
		return methodDefSupport_.getMethodDefSize();
	}

	/**
	 * @see org.seasar.framework.container.AspectDefAware#getAspectDefSize()
	 */
	public int getAspectDefSize() {
		return aspectDefSupport_.getAspectDefSize();
	}
	
	/**
	 * @see org.seasar.framework.container.ComponentDef#getInitMethodName()
	 */
	public String getInitMethodName() {
		return initMethodName_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#setInitMethodName(java.lang.String)
	 */
	public void setInitMethodName(String initMethodName) {
		initMethodName_ = initMethodName;
	}
	
	/**
	 * @see org.seasar.framework.container.ComponentDef#getDestroyMethodName()
	 */
	public String getDestroyMethodName() {
		return destroyMethodName_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#setDestroyMethodName(java.lang.String)
	 */
	public void setDestroyMethodName(String destroyMethodName) {
		destroyMethodName_ = destroyMethodName;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getInstanceMode()
	 */
	public String getInstanceMode() {
		return instanceMode_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#setInstanceMode(java.lang.String)
	 */
	public void setInstanceMode(String instanceMode) {
		if (InstanceModeUtil.isSingleton(instanceMode)
			|| InstanceModeUtil.isPrototype(instanceMode)) {

			instanceMode_ = instanceMode;
		} else {
			throw new IllegalArgumentException(instanceMode);
		}
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#getAutoBindingMode()
	 */
	public String getAutoBindingMode() {
		return autoBindingMode_;
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#setAutoBindingMode(java.lang.String)
	 */
	public void setAutoBindingMode(String autoBindingMode) {
		if (AutoBindingUtil.isAuto(autoBindingMode)
			|| AutoBindingUtil.isConstructor(autoBindingMode)
			|| AutoBindingUtil.isProperty(autoBindingMode)
			|| AutoBindingUtil.isNone(autoBindingMode)) {

			autoBindingMode_ = autoBindingMode;
		} else {
			throw new IllegalArgumentException(autoBindingMode);
		}
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#init()
	 */
	public void init() {
		getComponentDeployer().init();
	}

	/**
	 * @see org.seasar.framework.container.ComponentDef#destroy()
	 */
	public void destroy() {
		getComponentDeployer().destroy();
	}

	/**
	 * @see org.seasar.framework.container.ArgDefAware#getArgDef(int)
	 */
	public ArgDef getArgDef(int index) {
		return argDefSupport_.getArgDef(index);
	}

	/**
	 * @see org.seasar.framework.container.PropertyDefAware#getPropertyDef(int)
	 */
	public PropertyDef getPropertyDef(int index) {
		return propertyDefSupport_.getPropertyDef(index);
	}

	/**
	 * @see org.seasar.framework.container.MethodDefAware#getMethodDef(int)
	 */
	public MethodDef getMethodDef(int index) {
		return methodDefSupport_.getMethodDef(index);
	}

	/**
	 * @see org.seasar.framework.container.AspectDefAware#getAspectDef(int)
	 */
	public AspectDef getAspectDef(int index) {
		return aspectDefSupport_.getAspectDef(index);
	}

	private ComponentDeployer getComponentDeployer() {
		if (componentDeployer_ != null) {
			return componentDeployer_;
		}
		synchronized (this) {
			if (componentDeployer_ == null) {
				componentDeployer_ = ComponentDeployerFactory.create(this);
			}
		}
		return componentDeployer_;
	}
}
