package org.seasar.framework.container.factory;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.impl.MethodDefImpl;
import org.seasar.framework.xml.sax.handler.TagHandler;
import org.seasar.framework.xml.sax.handler.TagHandlerContext;
import org.xml.sax.Attributes;

/**
 * @author higa
 *
 */
public class MethodTagHandler extends TagHandler {

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#start(org.seasar.framework.xml.sax.handler.TagHandlerContext, org.xml.sax.Attributes)
	 */
	public void start(TagHandlerContext context, Attributes attributes) {
		String name = attributes.getValue("name");
		if (name == null) {
			throw new TagAttributeNotDefinedRuntimeException("method", "name");
		}
		context.push(new MethodDefImpl(name));
	}

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#end(org.seasar.framework.xml.sax.handler.TagHandlerContext, java.lang.String)
	 */
	public void end(TagHandlerContext context, String body) {
		MethodDef methodDef = (MethodDef) context.pop();
		ComponentDef componentDef = (ComponentDef) context.peek();
		componentDef.addMethodDef(methodDef);
	}

}
