package org.seasar.framework.container.factory;

import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.util.string.StringUtil;
import org.seasar.framework.xml.sax.handler.TagHandler;
import org.seasar.framework.xml.sax.handler.TagHandlerContext;
import org.xml.sax.Attributes;

/**
 * @author higa
 *
 */
public class AspectTagHandler extends TagHandler {

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#start(org.seasar.framework.xml.sax.handler.TagHandlerContext, org.xml.sax.Attributes)
	 */
	public void start(TagHandlerContext context, Attributes attributes) {
		AspectDef aspectDef = null;
		String pointcutStr = attributes.getValue("pointcut");
		if (pointcutStr != null) {
			String[] methodNames = StringUtil.split(pointcutStr, ", ");
			aspectDef = new AspectDefImpl(new PointcutImpl(methodNames));
		} else {
			aspectDef = new AspectDefImpl();
		}
		context.push(aspectDef);
	}

	/**
	 * @see org.seasar.framework.xml.sax.handler.TagHandler#end(org.seasar.framework.xml.sax.handler.TagHandlerContext, java.lang.String)
	 */
	public void end(TagHandlerContext context, String body) {
		AspectDef aspectDef = (AspectDef) context.pop();
		if (!StringUtil.isEmpty(body)) {
			aspectDef.setExpression(body);
		}
		ComponentDef componentDef = (ComponentDef) context.peek();
		componentDef.addAspectDef(aspectDef);
	}
}
