package org.seasar.framework.container.deployer.factory;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.deployer.ComponentDeployer;
import org.seasar.framework.container.deployer.PrototypeComponentDeployer;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.util.InstanceModeUtil;

/**
 * @author higa
 *
 */
public final class ComponentDeployerFactory {

	private ComponentDeployerFactory() {
	}

	public static ComponentDeployer create(ComponentDef componentDef) {
		if (InstanceModeUtil.isSingleton(componentDef.getInstanceMode())) {
			return new SingletonComponentDeployer(componentDef);
		} else {
			return new PrototypeComponentDeployer(componentDef);
		}
	}
}
