package org.seasar.framework.container.deployer;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.CyclicReferenceRuntimeException;

/**
 * @author higa
 *
 */
public class SingletonComponentDeployer extends AbstractComponentDeployer {

	private Object component_;
	private boolean instantiating_;
	/**
	 * @param componentDef
	 */
	public SingletonComponentDeployer(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.deployer.ComponentDeployer#deploy()
	 */
	public Object deploy() {
		if (component_ != null) {
			return component_;
		}
		synchronized (this) {
			if (component_ == null) {
				assemble();
			}
		}
		return component_;
	}

	private void assemble() {
		if (instantiating_) {
			throw new CyclicReferenceRuntimeException(
				getComponentDef().getComponentClass());
		}
		instantiating_ = true;
		component_ = getConstructorAssembler().assemble();
		instantiating_ = false;
		getPropertyAssembler().assemble(component_);
		getMethodAssembler().assemble(component_);
	}
	
	/**
	 * @see org.seasar.framework.container.deployer.ComponentDeployer#init()
	 */
	public void init() {
		deploy();
		invoke(getComponentDef().getInitMethodName());
	}
	
	/**
	 * @see org.seasar.framework.container.deployer.ComponentDeployer#destroy()
	 */
	public void destroy() {
		invoke(getComponentDef().getDestroyMethodName());
	}
	
	private void invoke(String methodName) {
		if (methodName != null) {
			BeanDesc beanDesc = BeanDescFactory.getBeanDesc(
				getComponentDef().getComponentClass());
			beanDesc.invoke(component_, methodName, null);
		}
	}
}
