package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.AutoConstructorAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.ConstructorAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.DefaultConstructorAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.constructor
	.ManualConstructorAssembler;
import org.seasar.framework.container.assembler.method.DefaultMethodAssembler;
import org.seasar.framework.container.assembler.method.MethodAssembler;
import org.seasar.framework.container.assembler.property.AutoPropertyAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.property
	.DefaultPropertyAssembler;
import org
	.seasar
	.framework
	.container
	.assembler
	.property
	.ManualPropertyAssembler;
import org.seasar.framework.container.assembler.property.PropertyAssembler;
import org.seasar.framework.container.util.AutoBindingUtil;

/**
 * @author higa
 *
 */
public abstract class AbstractComponentDeployer implements ComponentDeployer {

	private ComponentDef componentDef_;
	private ConstructorAssembler constructorAssembler_;
	private PropertyAssembler propertyAssembler_;
	private MethodAssembler methodAssembler_;

	public AbstractComponentDeployer(ComponentDef componentDef) {
		componentDef_ = componentDef;
		setupAssembler();
	}

	protected final ComponentDef getComponentDef() {
		return componentDef_;
	}

	protected final ConstructorAssembler getConstructorAssembler() {
		return constructorAssembler_;
	}

	protected final PropertyAssembler getPropertyAssembler() {
		return propertyAssembler_;
	}

	protected final MethodAssembler getMethodAssembler() {
		return methodAssembler_;
	}

	private void setupAssembler() {
		String autoBindingMode = componentDef_.getAutoBindingMode();
		if (AutoBindingUtil.isAuto(autoBindingMode)) {
			setupAssemblerForAuto();
		} else if (AutoBindingUtil.isConstructor(autoBindingMode)) {
			setupAssemblerForConstructor();
		} else if (AutoBindingUtil.isProperty(autoBindingMode)) {
			setupAssemblerForProperty();
		} else if (AutoBindingUtil.isNone(autoBindingMode)) {
			setupAssemblerForNone();
		} else {
			throw new IllegalArgumentException(autoBindingMode);
		}
		methodAssembler_ = new DefaultMethodAssembler(componentDef_);
	}

	private void setupAssemblerForAuto() {
		if (componentDef_.getArgDefSize() > 0) {
			constructorAssembler_ =
				new ManualConstructorAssembler(componentDef_);
			propertyAssembler_ = new DefaultPropertyAssembler(componentDef_);
		} else if (componentDef_.getPropertyDefSize() > 0) {
			constructorAssembler_ =
				new DefaultConstructorAssembler(componentDef_);
			propertyAssembler_ = new ManualPropertyAssembler(componentDef_);
		} else {
			AutoConstructorAssembler assembler =
				new AutoConstructorAssembler(componentDef_);
			if (assembler.getSuitableConstructor() != null) {
				constructorAssembler_ = assembler;
				propertyAssembler_ =
					new DefaultPropertyAssembler(componentDef_);
			} else {
				constructorAssembler_ =
					new DefaultConstructorAssembler(componentDef_);
				propertyAssembler_ = new AutoPropertyAssembler(componentDef_);
			}
		}
	}

	private void setupAssemblerForConstructor() {
		if (componentDef_.getArgDefSize() > 0) {
			constructorAssembler_ =
				new ManualConstructorAssembler(componentDef_);
		} else {
			constructorAssembler_ = new AutoConstructorAssembler(componentDef_);
		}
		propertyAssembler_ = new DefaultPropertyAssembler(componentDef_);
	}

	private void setupAssemblerForProperty() {
		constructorAssembler_ = new DefaultConstructorAssembler(componentDef_);
		propertyAssembler_ = new AutoPropertyAssembler(componentDef_);
	}

	private void setupAssemblerForNone() {
		if (componentDef_.getArgDefSize() > 0) {
			constructorAssembler_ =
				new ManualConstructorAssembler(componentDef_);
			propertyAssembler_ = new DefaultPropertyAssembler(componentDef_);
		} else if (componentDef_.getPropertyDefSize() > 0) {
			constructorAssembler_ =
				new DefaultConstructorAssembler(componentDef_);
			propertyAssembler_ = new ManualPropertyAssembler(componentDef_);
		} else {
			constructorAssembler_ =
				new DefaultConstructorAssembler(componentDef_);
			propertyAssembler_ = new DefaultPropertyAssembler(componentDef_);
		}
	}
}
