package org.seasar.framework.container.assembler.property;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentDef;
import org
	.seasar
	.framework
	.container
	.IllegalPropertyConfigurationRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.AutoBindingUtil;

/**
 * @author higa
 *
 */
public class AutoPropertyAssembler extends AbstractPropertyAssembler {

	/**
	 * @param componentDef
	 */
	public AutoPropertyAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.property.PropertyAssembler#assemble(java.lang.Object)
	 */
	public void assemble(Object component) {
		BeanDesc beanDesc = getBeanDesc();
		S2Container container = getComponentDef().getContainer();
		for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
			PropertyDesc propDesc = beanDesc.getPropertyDesc(i);
			if (propDesc.getWriteMethod() != null
				&& AutoBindingUtil.isSuitable(propDesc.getPropertyType())) {
				Object value = null;
				try {
					value = container.getComponent(propDesc.getPropertyType());
					propDesc.setValue(component, value);
				} catch (Throwable cause) {
					throw new IllegalPropertyConfigurationRuntimeException(
						getComponentDef().getComponentClass(),
						propDesc.getPropertyName(),
						cause);
				}
			}
		}
	}

}
