package org.seasar.framework.container.assembler.method;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalMethodConfigurationRuntimeException;
import org.seasar.framework.container.MethodDef;

/**
 * @author higa
 *
 */
public class DefaultMethodAssembler extends AbstractMethodAssembler {

	/**
	 * @param componentDef
	 */
	public DefaultMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.method.MethodAssembler#assemble(java.lang.Object)
	 */
	public void assemble(Object component)
		throws IllegalMethodConfigurationRuntimeException {

		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getMethodDefSize();
		for (int i = 0; i < size; ++i) {
			MethodDef methodDef = getComponentDef().getMethodDef(i);
			Object[] args = null;
			try {
				args = methodDef.getArgs();
				beanDesc.invoke(
					component,
					methodDef.getMethodName(),
					args); 
			} catch (Throwable cause) {
				throw new IllegalMethodConfigurationRuntimeException(
					getComponentDef().getComponentClass(),
					methodDef.getMethodName(), cause);
			}
		}
	}

}
