package org.seasar.framework.container.assembler.constructor;

import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalConstructorConfigurationRuntimeException;

/**
 * @author higa
 *
 */
public final class ManualConstructorAssembler
	extends AbstractConstructorAssembler {

	/**
	 * @param componentDef
	 */
	public ManualConstructorAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	/**
	 * @see org.seasar.framework.container.assembler.ComponentFactory#create()
	 */
	public Object assemble() throws IllegalConstructorConfigurationRuntimeException {
		try {
			Object[] args = new Object[getComponentDef().getArgDefSize()];
			for (int i = 0; i < args.length; ++i) {
				args[i] = getComponentDef().getArgDef(i).getValue();
			}
			BeanDesc beanDesc =
				BeanDescFactory.getBeanDesc(getComponentDef().getComponentClass());
			if (getComponentDef().getAspectDefSize() > 0) {
				AopProxy aopProxy = createAopProxy();
				return aopProxy.create(
					beanDesc.getSuitableConstructor(args).getParameterTypes(),
					args);
			} else {
				return beanDesc.newInstance(args);
			}
		} catch (Throwable cause) {
			throw new IllegalConstructorConfigurationRuntimeException(
				getComponentDef().getComponentClass(), cause);
		}
		
	}
}
