package org.seasar.framework.container.assembler.constructor;

import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org
	.seasar
	.framework
	.container
	.IllegalConstructorConfigurationRuntimeException;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.util.reflect.ClassUtil;

/**
 * @author higa
 *
 */
public abstract class AbstractConstructorAssembler
	extends AbstractAssembler
	implements ConstructorAssembler {

	public AbstractConstructorAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	protected final AopProxy createAopProxy() {
		return new AopProxy(
			getComponentDef().getComponentClass(),
			getAspects());
	}

	protected Object assembleDefault() {
		try {
			if (getComponentDef().getAspectDefSize() > 0) {
				AopProxy aopProxy = createAopProxy();
				return aopProxy.create();
			} else {
				return ClassUtil.newInstance(
					getComponentDef().getComponentClass());
			}
		} catch (Throwable cause) {
			throw new IllegalConstructorConfigurationRuntimeException(
				getComponentDef().getComponentClass(),
				cause);
		}
	}

	private Aspect[] getAspects() {
		int size = getComponentDef().getAspectDefSize();
		Aspect[] aspects = new Aspect[size];
		for (int i = 0; i < size; ++i) {
			AspectDef aspectDef = getComponentDef().getAspectDef(i);
			aspects[i] = aspectDef.getAspect();
		}
		return aspects;
	}
}
