// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
/*
_global.showWelcomeStrings = function(target_mc) {
	target_mc.welcomeHeadline_txt.text = _global.appStrings.WELCOME_PREFIX_HD_str + _global.appTitle_str;
	target_mc.welcomeBody_txt.text = _global.appStrings.WELCOME_BODY_str;
}
*/
//----------------------------------------------------------------------
//	_global.errorBox
//----------------------------------------------------------------------
_global.errorBox = function(title, msg, callback, callBackContextObject)
{
	_global.showMainMessageBox(title, msg, "error", true, callback, callBackContextObject);
}

//----------------------------------------------------------------------
//	_global.confirmBox
//----------------------------------------------------------------------
_global.confirmBox = function(title, msg, callback, callBackContextObject)
{
	_global.showMainMessageBox(title, msg, "info", true, callback, callBackContextObject);
}

//----------------------------------------------------------------------
//	_global.warningBox
//----------------------------------------------------------------------
_global.warningBox = function(title, msg, callback, callBackContextObject)
{
	_global.showMainMessageBox(title, msg, "warning", true, callback, callBackContextObject);
}

//----------------------------------------------------------------------
//	_global.progressBox
//----------------------------------------------------------------------
_global.progressBox = function(title, msg, callback, callBackContextObject)
{
	var mb = _global.showMainMessageBox(title, msg, "", false, callback, callBackContextObject);
	return mb;
}

//----------------------------------------------------------------------
//	_global.showMainMessageBox
//----------------------------------------------------------------------
_global.showMainMessageBox = function(title, msg, iconName, needOKBtn, callback, callBackContextObject, largeBox)
{
	var main_mbHolder_mc = (_root.main_mc.main_mbHolder_mc == undefined) ? _root.main_mbHolder_mc : _root.main_mc.main_mbHolder_mc;
	if(main_mbHolder_mc.main_mb != undefined){
		main_mbHolder_mc.main_mb.removeMovieClip();
	}
	var width = (largeBox) ? 500 : 350;
	var height = (largeBox) ? 300 : 225;
	var main_mb = main_mbHolder_mc.attachMovie("FMessageBoxSymbol", "main_mb", 1);

	main_mb.setMessage(msg);
	if(needOKBtn){
		main_mb.setButtons([_global.appStrings.OK_BTN_LBL_str]);
	}
	main_mb.setTitle(title);
	main_mb.setIcon(iconName);
	// Invoke 2 callbacks when the message box closes:
	// 	- the first callback restores the tabs
	// 	- the second callback is the one passed in
	_global.mboxTabRestorer.targetObject = callBackContextObject;
	_global.mboxTabRestorer.targetCallback = callback;
	main_mb.setCloseHandler("callback", _global.mboxTabRestorer);
	main_mb.setSize(width, height);
	// TRICKY: This relies on insider info for the message box.  It was added so that the 
	// message box button gets focus.
	if(needOKBtn){
		var tabCatcher = new Object();
		tabCatcher[main_mb["buttons_mc0"]._target] = 1;
		_global.mboxTabRestorer.oldActiveTabs = _global.tabController.setActiveTabs(tabCatcher);
		main_mb["buttons_mc0"].myOnKeyDown = _global.buttonOnKeyDown;
		main_mb["buttons_mc0"].myOnKeyUp = _global.buttonOnKeyUp;
		Selection.setFocus(main_mb["buttons_mc0"]);
	}
	return main_mb;
}

// This object:
// 	- defines a callback that restores tabs
// 	- holds the original callback functions for the messagebox
_global.mboxTabRestorer = new Object();

//----------------------------------------------------------------------
//	_global.mboxTabRestorer.callback
//----------------------------------------------------------------------
_global.mboxTabRestorer.callback = function(mb, btn_idx) {
	if(this.oldActiveTabs != null) {
		_global.tabController.setActiveTabs(this.oldActiveTabs);
		this.oldActiveTabs = null;
	}
	_global.mboxTabRestorer.targetObject[_global.mboxTabRestorer.targetCallback](mb, btn_idx);
}
	
//----------------------------------------------------------------------
//	_global.dieToErrorPage
//----------------------------------------------------------------------
_global.dieToErrorPage = function (qs) {
	if(_global.logErrorURI != undefined) {
		var infoToPost = new LoadVars();
		infoToPost.os = System.Capabilities.os;
		infoToPost.flashVers = System.Capabilities.version;
		infoToPost.send(_global.logErrorURI);
	}
	_root.getURL(_global.errorPage+"?"+qs, "_top");
}

_global.goHome = function() {
	var main_mc_tl = (_root.main_mc == undefined) ? _root : _root.main_mc;
	if(_global.cartWidget_mc.isInCheckout){
		_global.cartWidget_mc.leaveCheckout();
		main_mc_tl.shouldReset = true;
		main_mc_tl.gotoAndPlay("exitCheckout");
	} else {
		_global.resetUI();
		if(main_mc_tl.currUIState == "home") {
			main_mc_tl.gotoAndStop("home");
		}
		else {
			main_mc_tl.gotoAndPlay("home");
		}
	}
}

//----------------------------------------------------------------------
//	_global.resetUI
//
//	Collapses all pre-checkout UI elements.
//----------------------------------------------------------------------
_global.resetUI = function() {
	var main_mc_tl = (_root.main_mc == undefined) ? _root : _root.main_mc;
	main_mc_tl.itemBrowsing_mc._visible = false;
	_global.categoryUI.reset();
	_global.widgetGroupObj.collapseAll();
}

//----------------------------------------------------------------------
//	_global.statusToQS
//
//	serializes FlashRemoting.onStatus object into a QS
//----------------------------------------------------------------------
_global.statusToQS = function (data) {
	var qs = "code=" + escape(data.code) + "&class=" +
				escape(data.class) + "&description=" + escape(data.description) +
				"&details=" + escape(data.details);
	
	return qs;
}

//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
