// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
//----------------------------------------------------------------------
//
// utility function definitions
// 
//
/*
	This file contains functions only, and is not associated with a movie clip.

	The functions below are mostly locale independent, but they are grouped
	here so that they may be changed if necessary.

	The functions format strings.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A (included on main timeline)

			Library Path:		
*/
//
//

//----------------------------------------------------------------------
//	_global.formatForCurrency
//----------------------------------------------------------------------
_global.formatForCurrency = function(data) {
	var negation = "";
	var num = parseFloat(data);
	if(num < 0){
		negation = "-";
		num = Math.abs(num);
	}
	if (isNaN(num)){
		return data;;
	}
	if(typeof data == "string"){
		if(data.indexOf(",") != -1) {
			var commaSplit_array = data.split(",");
			var num_str = "";
			for(i=0; i < commaSplit_array.length; i++){
				num_str += commaSplit_array[i];
			}
			num = parseFloat(num_str);
		}
	}
	var num_str = _global.numberToDisplayString(num);
	var money_str = _global.appStrings.CURRENCY_SYMBOL_str + negation + num_str; 
	return money_str;
}

//----------------------------------------------------------------------
//	_global.formatShipDate
//----------------------------------------------------------------------
_global.formatShipDate = function(ship_date) {
	return _global.appStrings.WEEKDAY_NAMES_array[ship_date.getDay()] + ", " +
				_global.appStrings.MONTH_NAMES_array[ship_date.getMonth()] + " " + 
				ship_date.getDate();
}

//----------------------------------------------------------------------
//	_global.numberToDisplayString
//----------------------------------------------------------------------
_global.numberToDisplayString = function(num)
{
	var display_str = num.toString();
	var decimalIndex = display_str.indexOf(".");
	var decimalOffset = (decimalIndex == -1) ? -1 : (display_str.length - 1) - decimalIndex;
	if(decimalOffset != 2){
		if (decimalOffset == -1){
			display_str += _global.appStrings.CURRENCY_DECIMAL_str + "00";
		}
		else if (decimalOffset == 0){
			display_str += "00";
		}
		else if (decimalOffset == 1){
			display_str += "0";
		}
		else if(decimalOffset > 2){ // If more than 2 decimal places, round-up.
			var roundUpDecimal = display_str.substr(decimalIndex + 1, 2)+ "." + display_str.substr(decimalIndex + 3);
			roundUpDecimal = Math.ceil(roundUpDecimal);
			display_str = display_str.substring(0, decimalIndex + 1) + roundUpDecimal;
		}
	}
	if(display_str.indexOf(".") > 3){ // Add thousands separator - works up to < One MILLION
		display_str = display_str.substring(0, display_str.length - 6) + _global.appStrings.THOUSANDS_SEPARATOR_str + display_str.substring(display_str.length - 6);
	}
	return display_str;
}
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
