#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/catalog/GetProducts.as"

if (test.petmarket.service.catalog.GetProductsTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.catalog.GetProductsTest",
		seasar.unit.TestCase, ["service"]);
	
	var proto = test.petmarket.service.catalog.GetProductsTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.service = new petmarket.service.catalog.GetProducts(conn);
	}
	
	proto.tearDown = function() {
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.getProductsPerformed = function(data) {
			trace("listener.getProductsPerformed:" + data.getLength());
		}
		seasar.event.Broadcaster.addEventListener("getProducts", listener);
		this.service.execute(1);
	}

	delete proto;
}