#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "seasar/nazuna/NzRecordSet.as"
#include "petmarket/service/cart/Cart.as"
#include "petmarket/service/cart/NewCartOid.as"

if (test.petmarket.service.cart.NewCartOidTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.cart.NewCartOidTest",
		seasar.unit.TestCase, ["cart", "service"]);
	
	var proto = test.petmarket.service.cart.NewCartOidTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.cart = new petmarket.service.cart.Cart(conn);
		this.service = new petmarket.service.cart.NewCartOid(conn, this.cart);
	}
	
	proto.tearDown = function() {
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.cart = this.cart;
		listener.newCartOidPerformed = function(data) {
			trace("listener.newCartOidPerformed:" + data);
			trace("listener.cart.cartOid:" + this.cart.cartOid);
		}
		seasar.event.Broadcaster.addEventListener("newCartOid", listener);
		this.service.execute();
	}

	delete proto;
}