#include "NetServices.as"
#include "seasar/lang/SObject.as"
#include "seasar/unit/TestCase.as"
#include "seasar/event/Broadcaster.as"
#include "petmarket/service/cart/Cart.as"
#include "petmarket/service/cart/GetShippingMethods.as"

if (test.petmarket.service.cart.GetShippingMethodsTest === undefined) {
	seasar.lang.SObject.defineClass("test.petmarket.service.cart.GetShippingMethodsTest",
		seasar.unit.TestCase, ["cart", "service"]);
	
	var proto = test.petmarket.service.cart.GetShippingMethodsTest.prototype;
	
	proto.setUp = function() {
		NetServices.setDefaultGatewayUrl("http://localhost:8080/petmarket/gateway");
		var conn = NetServices.createGatewayConnection();
		this.cart = new petmarket.service.cart.Cart(conn);
		this.service = new petmarket.service.cart.GetShippingMethods(conn, this.cart);
	}
	
	proto.tearDown = function() {
		this.service = null;
	}
	
	proto.testExecute = function() {
		var listener = new Object();
		listener.cart = this.cart;
		listener.getShippingMethodsServerPerformed = function(data) {
			trace("listener.getShippingMethodsServerPerformed:" + data);
			trace("listener.cart.shippingMethods:" + this.cart.shippingMethods);
		}
		seasar.event.Broadcaster.addEventListener("getShippingMethodsServer", listener);
		this.service.execute();
	}

	delete proto;
}