#include "seasar/lang/SObject.as"
#include "seasar/nazuna/RuleEventService.as"
#include "seasar/event/Broadcaster.as"
	
if (petmarket.service.cart.NewCartOid === undefined) {
	seasar.lang.SObject.defineClass("petmarket.service.cart.NewCartOid", seasar.nazuna.RuleEventService,
		"cart",
		function(conn, cart) {
			super(conn, "petmarket.rule.cart.NewCartOid", "newCartOid", "newCartOidStatus");
			this.cart = cart;
		});
		
	var proto = petmarket.service.cart.NewCartOid.prototype;
	
	proto.execute = function() {
		trace("newCartOid");
		this.rule.execute();
	}
	
	proto.onResult = function(cartOid) {
		this.cart.cartOid = cartOid;
		super.onResult(cartOid);
	}
	
	delete proto;
}