// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
/*
	This file contains functions only, and is associated with the main timeline of the functions.

	It consolidates all the code that governs widget appearance.

	#include info for this file:

			FLA:				fui_components.fla

			Layer:				Actions : Utility Functions

			Frame:				1

			Library Symbol:		N/A (included on main timeline)

			Library Path:		
*/

//------------------------------------------------------------
// TextFormat Objects
//
// 	Initialize all of the text format objects used in the
// 	application and store them globally for later use.
//------------------------------------------------------------

_global.topNavBtnLabel_fmt = new TextFormat(_global.embeddedFonts.head.font, 12, 0x666666, _global.embeddedFonts.head.bold, _global.embeddedFonts.head.italic);
_global.formBtnLabel_fmt = new TextFormat(_global.embeddedFonts.head.font, 12, 0xFFFFFF, _global.embeddedFonts.head.bold, _global.embeddedFonts.head.italic);
_global.hiliteWidgetBtnLabel_fmt = new TextFormat(_global.embeddedFonts.head.font, 12, 0xFFFFFF, _global.embeddedFonts.head.bold, _global.embeddedFonts.head.italic);
_global.catNavLabel_fmt = new TextFormat(_global.embeddedFonts.head.font, 16, 0x000000, _global.embeddedFonts.head.bold, _global.embeddedFonts.head.italic);
_global.globalStyleFormatTextFormat_fmt = new TextFormat(_global.embeddedFonts.body.font, 12, 0x000000, _global.embeddedFonts.body.bold, _global.embeddedFonts.body.italic);
_global.smallText_fmt = new TextFormat(_global.embeddedFonts.body.font, 11, 0x000000, _global.embeddedFonts.body.bold, _global.embeddedFonts.body.italic);
_global.smallTextRight_fmt = new TextFormat(_global.embeddedFonts.body.font, 11, 0x000000, _global.embeddedFonts.body.bold, _global.embeddedFonts.body.italic, false, "", "", "right");
_global.messageBoxTitleText_fmt = new TextFormat(_global.embeddedFonts.head.font, 14, 0x333333, _global.embeddedFonts.head.bold, _global.embeddedFonts.head.italic);


//------------------------------------------------------------
// Button Format Objects
//
//  These objects hold all the style info for buttons.
//------------------------------------------------------------
_global.topNavIconBtnFormat = new Object();
_global.topNavIconBtnFormat.labelFormat = _global.topNavBtnLabel_fmt;
_global.topNavIconBtnFormat.styles = new Object();
_global.topNavIconBtnFormat.styles.textFont = _global.topNavIconBtnFormat.labelFormat.font;
_global.topNavIconBtnFormat.styles.textBold = _global.topNavIconBtnFormat.labelFormat.bold;
_global.topNavIconBtnFormat.styles.textSize = _global.topNavIconBtnFormat.labelFormat.size;
_global.topNavIconBtnFormat.styles.textColor = _global.topNavIconBtnFormat.labelFormat.color;
_global.topNavIconBtnFormat.styles.embedFonts = true;
_global.topNavIconBtnFormat.styles.face = 0xFFFFFF;
_global.topNavIconBtnFormat.styles.shadow = 0xFFFFFF;
_global.topNavIconBtnFormat.styles.darkshadow = 0xFFFFFF;
_global.topNavIconBtnFormat.styles.highlight = 0xFFFFFF;
_global.topNavIconBtnFormat.styles.highlight3D = 0xFFFFFF;
_global.topNavIconBtnFormat.labelPlacement = "right";
_global.topNavIconBtnFormat.background_mc = null;
_global.topNavIconBtnFormat.icon_mc = "topNavBtnIcon_mc";
_global.topNavIconBtnFormat.xPadding = 16;
_global.topNavIconBtnFormat.minWidth = 50;
_global.topNavIconBtnFormat.btnHeight = 22;

_global.formIconBtnFormat = new Object();
_global.formIconBtnFormat.labelFormat = _global.formBtnLabel_fmt;
_global.formIconBtnFormat.styles = new Object();
_global.formIconBtnFormat.styles.textFont = _global.formIconBtnFormat.labelFormat.font;
_global.formIconBtnFormat.styles.textBold = _global.formIconBtnFormat.labelFormat.bold;
_global.formIconBtnFormat.styles.textSize = _global.formIconBtnFormat.labelFormat.size;
_global.formIconBtnFormat.styles.textColor = _global.formIconBtnFormat.labelFormat.color;
_global.formIconBtnFormat.styles.embedFonts = true;
_global.formIconBtnFormat.labelPlacement = "right";
_global.formIconBtnFormat.background_mc = "mainIconButtonBG_mc";
_global.formIconBtnFormat.icon_mc = null;
_global.formIconBtnFormat.xPadding = 16;
_global.formIconBtnFormat.minWidth = 50;
_global.formIconBtnFormat.btnHeight = 25;

_global.hiliteWidgetIconBtnFormat = new Object();
_global.hiliteWidgetIconBtnFormat.labelFormat = _global.hiliteWidgetBtnLabel_fmt;
_global.hiliteWidgetIconBtnFormat.styles = new Object();
_global.hiliteWidgetIconBtnFormat.styles.textFont = _global.hiliteWidgetIconBtnFormat.labelFormat.font;
_global.hiliteWidgetIconBtnFormat.styles.textBold = _global.hiliteWidgetIconBtnFormat.labelFormat.bold;
_global.hiliteWidgetIconBtnFormat.styles.textSize = _global.hiliteWidgetIconBtnFormat.labelFormat.size;
_global.hiliteWidgetIconBtnFormat.styles.textColor = _global.hiliteWidgetIconBtnFormat.labelFormat.color;
_global.hiliteWidgetIconBtnFormat.styles.embedFonts = true;
_global.hiliteWidgetIconBtnFormat.labelPlacement = "right";
_global.hiliteWidgetIconBtnFormat.background_mc = "widgetIconButtonBG_mc";
_global.hiliteWidgetIconBtnFormat.icon_mc = null;
_global.hiliteWidgetIconBtnFormat.xPadding = 16;
_global.hiliteWidgetIconBtnFormat.minWidth = 50;
_global.hiliteWidgetIconBtnFormat.btnHeight = 25;


//----------------------------------------------------------------------
//	_global.sizeAndFormatIconBtn
//
// Applies styling, label, and sizes the button based on label text.
//
// If the optional boolean is true, it will force the method to store the
// original right edge position of the button so it can be re-positioned
// after resizing to maintain the same right-alignment.
//----------------------------------------------------------------------
_global.sizeAndFormatIconBtn = function(btn_ib, label_str, formatObj, authorTimeRightAlign)
{
	for(prop in formatObj.styles){
		btn_ib.setStyleProperty(prop, formatObj.styles[prop]);
	}
	if(formatObj.icon_mc != null){btn_ib.setIcon(formatObj.icon_mc);}
	if(formatObj.background_mc != null){btn_ib.setBackground(formatObj.background_mc);}
	btn_ib.setLabel(label_str);
	var stringWidth = formatObj.labelFormat.getTextExtent(label_str).width;
	//:TRICKY: MacOS returns Twips (pixels*20)
	if(System.capabilities.os.indexOf("Mac OS") != -1){stringWidth = Math.floor(stringWidth / 20);}
	var btnWidth = stringWidth + (formatObj.xPadding * 2);
	if(formatObj.minWidth > btnWidth){btnWidth = formatObj.minWidth;}
	if(authorTimeRightAlign){
		if(btn_ib.rightEdge == null){
			btn_ib.rightEdge = btn_ib._x + btn_ib._width;
		}
		btn_ib._x = btn_ib.rightEdge - btnWidth;
	}
	btn_ib.setLabelPlacement(formatObj.labelPlacement);
	btn_ib.setSize(btnWidth, formatObj.btnHeight);
	// TRICKY: add enter key handling to iconbtns
	btn_ib.myOnKeyDown = _global.buttonOnKeyDown;
	btn_ib.myOnKeyUp = _global.buttonOnKeyUp;
}

//----------------------------------------------------------------------
//	_global.initStyles
//
//	Applies style formats to all component via the Flash Component's
//	globalStyleFormat object.
//----------------------------------------------------------------------
_global.initStyles = function ()
{
	globalStyleFormat.highlight = 0xB2B2B2;
	globalStyleFormat.highlight3D = 0xFFFFFF;
	globalStyleFormat.face = 0xB2B2B2;
	globalStyleFormat.shadow = 0xB2B2B2;
	globalStyleFormat.darkshadow = 0x333333;
	globalStyleFormat.selection = 0xF5CBBE;
	globalStyleFormat.selectionUnfocused = 0xF5CBBE;
	globalStyleFormat.selectionDisabled = 0xF5CBBE;
	globalStyleFormat.background = 0xFFFFFF;
	globalStyleFormat.backgroundDisabled = 0xEEEEEE;
	globalStyleFormat.arrow = 0xFFFFFF;
	globalStyleFormat.foregroundDisabled = 0x666699;
	globalStyleFormat.scrollTrack = 0xCCCCCC;
	globalStyleFormat.mbTitleArea = 0xF5CBBE;
	globalStyleFormat.FMessageBoxTitleText = _global.messageBoxTitleText_fmt;
	globalStyleFormat.textFont = _global.globalStyleFormatTextFormat_fmt.font;
	globalStyleFormat.textSize = _global.globalStyleFormatTextFormat_fmt.size;
	globalStyleFormat.textColor = _global.globalStyleFormatTextFormat_fmt.color;
	globalStyleFormat.embedFonts = true;
	globalStyleFormat.textDisabled = 0x666699;
	globalStyleFormat.textSelected = 0x000000;
	globalStyleFormat.applyChanges();
}


//----------------------------------------------------------------------
//	_global.sizeAndFormatListBox
//
//	This function also overrides the default setSize function of 
//	listboxes.
//----------------------------------------------------------------------
_global.sizeAndFormatListBox = function(listBox_lb, rowCount, bezelDepth, width)
{
	// override the default setSize for listboxes
	listBox_lb.origSetSize = listBox_lb.setSize;
	listBox_lb.setSize = _global.lazySetSize;
	if(width != null){
		listBox_lb.setSize(width);
	}
	listBox_lb.measureItmHgt();
	listBox_lb.setRowCount(rowCount);
	_global.addListBoxBezel(listBox_lb, bezelDepth);
}

//----------------------------------------------------------------------
//	_global.lazySetSize
//
//	The default setSize function is expensive: it basically recreates 
//	all nested movie clips in the listbox.  We only call it if the listbox
//	size actually changes.  
//
//	Note: sometimes setSize is called when the size does not change and forces
//	the listbox to update.  That doesn't happen in the Pet Market application,
//	but does mean that this setSize override should only be applied very
//	carefully.
//	
//----------------------------------------------------------------------
_global.lazySetSize = function(w,h) { if(w != this.width || h != this.height) {
	this.origSetSize(w,h); } }

//------------------------------------------------------------
// ListBox Bezel Formatting
//------------------------------------------------------------
_global.listBoxBezel_mc = "listBoxBezel_mc";
_global.listBoxBezelYOffset = -1;
_global.listBoxBezelHeightOffset = 1;

//----------------------------------------------------------------------
//	_global.addListBoxBezel
//----------------------------------------------------------------------
_global.addListBoxBezel = function(listBox_lb, depth)
{
	if(depth == null){depth = 1;}
	var bezel_mc = listBox_lb._parent.attachMovie(_global.listBoxBezel_mc, "bezel_mc"+depth, depth);
	bezel_mc._width = listBox_lb._width;
	bezel_mc._height = listBox_lb._height + _global.listBoxBezelHeightOffset;
	bezel_mc._x = listBox_lb._x;
	bezel_mc._y = listBox_lb._y + _global.listBoxBezelYOffset;
	return bezel_mc;
}

//----------------------------------------------------------------------
//	_global.sizeAndFormatCombo
//----------------------------------------------------------------------
_global.sizeAndFormatCombo = function(component_mc, width, rowCount)
{
	//:TRICKY: Resets comboBox component's menu-holder for use in loaded SWF.
	var upTree = component_mc._parent;
		while(upTree._parent._parent != undefined){
			upTree = upTree._parent;
		}
	component_mc.superHolder.removeMovieClip();
	_global._popUpLevel = (_global._popUpLevel==undefined) ? 20000 : _global._popUpLevel+1;
	component_mc.superHolder = upTree.createEmptyMovieClip("superHolder" + _popUpLevel, _popUpLevel);
	component_mc.setSize(width);
	component_mc.setRowCount(rowCount);
}
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
