package test.petmarket.rule.user;

import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;
import org.seasar.util.Struct;

import petmarket.rule.RuleNames;


public class UpdateUserInfoTest extends NazunaTestCase implements RuleNames {

	public UpdateUserInfoTest(String arg0) {
		super(arg0);
	}

	public void testValidateUser() throws Exception {
		try {
			Nazuna.executeUpdate(UPDATE_USER_INFO, (Object) null);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testExecute() throws Exception {
		Struct user = (Struct) Nazuna.execute(ADD_USER, "hoge", "hoge");
		user.put("firstname", "firstname");
		user.put("lastname", "lastname");
		user.put("homephone", "homephone");
		user.put("shippingphone", "shippingphone");
		user.put("email", "email");
		user.put("password", "password");
		int num = Nazuna.executeUpdate(UPDATE_USER_INFO, (Object) user);
		assertEquals("1", 1, num);
		Map user2 = (Map) Nazuna.executeSingleQuery(GET_USER, "email");
		assertNotNull("2", user2);
		assertEquals("3", "firstname", user2.get("firstname"));
		assertEquals("4", "lastname", user2.get("lastname"));
		assertEquals("5", "homephone", user2.get("homephone"));
		assertEquals("6", "shippingphone", user2.get("shippingphone"));
		assertEquals("7", "password", user2.get("password"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateUserInfoTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
