package test.petmarket.rule.user;

import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;
import org.seasar.util.Struct;

import petmarket.rule.RuleNames;


public class UpdateShippingAddressTest extends NazunaTestCase implements RuleNames {

	public UpdateShippingAddressTest(String arg0) {
		super(arg0);
	}

	public void testValidateUser() throws Exception {
		try {
			Nazuna.executeUpdate(UPDATE_SHIPPING_ADDRESS, (Object) null);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testExecute() throws Exception {
		Struct user = (Struct) Nazuna.execute(ADD_USER, "hoge", "hoge");
		user.put("shippingstreet1", "shippingstreet1");
		user.put("shippingstreet2", "shippingstreet2");
		user.put("shippingcity", "shippingcity");
		user.put("shippingstate", "shippingstate");
		user.put("shippingcountry", "shippingcountry");
		user.put("shippingzip", "shippingzip");
		int num = Nazuna.executeUpdate(UPDATE_SHIPPING_ADDRESS, (Object) user);
		assertEquals("1", 1, num);
		Map user2 = (Map) Nazuna.executeSingleQuery(GET_USER, "hoge");
		assertNotNull("2", user2);
		assertEquals("3", "shippingstreet1", user2.get("shippingstreet1"));
		assertEquals("4", "shippingstreet2", user2.get("shippingstreet2"));
		assertEquals("5", "shippingcity", user2.get("shippingcity"));
		assertEquals("6", "shippingstate", user2.get("shippingstate"));
		assertEquals("7", "shippingcountry", user2.get("shippingcountry"));
		assertEquals("8", "shippingzip", user2.get("shippingzip"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateShippingAddressTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
