package test.petmarket.rule.user;

import java.util.Map;

import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.unit.NazunaTestCase;
import org.seasar.util.SeasarException;

import petmarket.rule.RuleNames;

public class SelectUserTest extends NazunaTestCase implements RuleNames {

	public SelectUserTest(String arg0) {
		super(arg0);
	}

	public void testValidateEmail() throws Exception {
		try {
			Nazuna.executeSingleQuery(SELECT_USER, null, "hoge");
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}
	
	public void testValidatePassword() throws Exception {
		try {
			Nazuna.executeSingleQuery(SELECT_USER, "hoge", null);
			fail("1");
		} catch (SeasarException ex) {
			System.out.println(ex);
		}
	}

	public void testExecute() throws Exception {
		Map user = (Map) Nazuna.execute(ADD_USER, "hoge@isid.co.jp", "hogepassword");
		Map user2 = (Map) Nazuna.executeSingleQuery(SELECT_USER, "hoge@isid.co.jp", "hogepassword");
		assertEquals("1", user.get("useroid"), user2.get("useroid"));
		assertEquals("2", user.get("email"), user2.get("email"));
		assertEquals("3", user.get("password"), user2.get("password"));
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(SelectUserTest.class);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
}
