// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip
//
/*

       

TopNavUI class


	The TopNavUI class encapsulates all UI behavior pertaining to
	the addition and management of the text-based button interface used
	across the top of the Pet Market application.


	This file is a pure ActionScript object that takes movie clip instances.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class Definitions

			Frame:				1

			Library Symbol:		N/A

			Library Path:		N/A


*/
//

// TopNavUIClass

//----------------------------------------------------------------------
//	TopNavUI
//		
//		The TopNavUI is the collection of buttons and drop down info
//		boxes at the top of the application
//----------------------------------------------------------------------
function TopNavUI()
{
	_global.topNav_mc = this;
	this.btnInit_array = new Array();
}

// Associate the TopNavUI class with the authortime topNavHolder_mc instance.
TopNavUI.prototype = new Movieclip();

Object.registerClass("topNavHolder_mc", TopNavUI);

TopNavUI.prototype = new MovieClip();

TopNavUI.prototype.btn_array = new Array();
TopNavUI.prototype.currentBtn_ib = null;
TopNavUI.prototype.currentInfo_mc = null;
TopNavUI.prototype.btnSpacing = 5;
TopNavUI.prototype.btnYPadding = 2;
TopNavUI.prototype.infoXOffset = 16;

TopNavUI.prototype.addButton = function(btnLabel, btnType, callback, stringServiceCall, infoFrameLabel) {
	this.btnInit_array.push({btnLabel : btnLabel, btnType : btnType, 
								callback : callback, 
								stringServiceCall : stringServiceCall, 
								infoFrameLabel : infoFrameLabel }
			);
}

//----------------------------------------------------------------------
// initButtons
//
// This function spreads the initialization of the topNav buttons over
// every third frame to allow main movie more time to operate.
//----------------------------------------------------------------------
TopNavUI.prototype.initButtons = function () {
	this.frameCount = 1;
	this.onEnterFrame = function() {
		if(this.frameCount % 10 == 0) {
			var obj = this.btnInit_array.shift();
			if(obj != null) {
				this.initButton(obj.btnLabel, obj.btnType, 
						obj.callback, obj.stringServiceCall, obj.infoFrameLabel);
			}
			else {
				delete this.onEnterFrame;
			}
		}
		++this.frameCount;
	}
}


//----------------------------------------------------------------------
// initButton
//
// This adds a button to the top nav.  It also sets up the info box
// and a server call the button can use to retrieve the info box content.
//----------------------------------------------------------------------
TopNavUI.prototype.initButton = function(btnLabel, btnType, callback, stringServiceCall, infoFrameLabel)
{	
	var btnCt = this.btn_array.length;
	var prev_ib = this.btn_array[btnCt-1];
  	var btn_ib = this.attachMovie("FIconButtonSymbol", "iconBtn"+btnCt, btnCt);
	this.btn_array.push(btn_ib);
	btn_ib.controller = this;
	btn_ib.btnType = btnType;
	btn_ib.setChangeHandler(callback, this);
	btn_ib.stringServiceCall = stringServiceCall;
	btn_ib.infoFrameLabel = infoFrameLabel;
	if(btnType == "infoBtn"){
		//Branched to allow application of a different _global format object for 'infoBtn'.
		_global.sizeAndFormatIconBtn(btn_ib, btnLabel, _global.topNavIconBtnFormat);
	}
	else if(btnType == "navBtn"){
		//Branched to allow application of a different _global format object for 'navBtn'.
		_global.sizeAndFormatIconBtn(btn_ib, btnLabel, _global.topNavIconBtnFormat);
	}
	else{
		//Branched to allow application of a default _global format object.
		_global.sizeAndFormatIconBtn(btn_ib, btnLabel, _global.topNavIconBtnFormat);
	}
	btn_ib._x = prev_ib._x - (btn_ib._width + this.btnSpacing);
	btn_ib._y = this.btnYPadding;
}

//----------------------------------------------------------------------
// infoBtnCallback
//
// Called when an info btn's clicked.
//----------------------------------------------------------------------
TopNavUI.prototype.infoBtnCallback = function(btn_ib)
{
	if(this.currentBtn == btn_ib){ // Close btn_ib's info_mc
		btn_ib.setIcon("topNavBtnIcon_mc");
		this.currentBtn = null;
		this.hideInfo();
	}
	else{
		if(btn_ib.info != undefined) {
			this.showInfo(btn_ib.info, btn_ib.infoFrameLabel, btn_ib);
		}
		else if(btn_ib.listening == undefined) {
			this.startListening(btn_ib, btn_ib.stringServiceCall);
			_global.stringResourcesRetriever[btn_ib.stringServiceCall]();
		}
		this.currentBtn.setIcon("topNavBtnIcon_mc");
		this.currentBtn = btn_ib;
		btn_ib.setIcon("topNavBtnCloseIcon_mc");
	}
}

//----------------------------------------------------------------------
// showInfo
//----------------------------------------------------------------------
TopNavUI.prototype.showInfo = function(info, infoFrameLabel, btn_ib)
{
	var btnTabber = new Object();
	btnTabber[btn_ib] = 1;
	// Remove all active tabs until the info box closes.
	this.activeTabs = _global.tabController.setActiveTabs(btnTabber);
	if(this.info_mc == undefined){
		this.attachMovie("infoDisplay_mc", "info_mc", -1);
		this.info_mc._x = this.infoXOffset - this.info_mc.infoBG_mc._width;
		this.info_mc.obscurer_mc.controller = this;
		this.info_mc.infoBG_mc.onPress = function(){}
		this.info_mc.infoBG_mc.useHandCursor = false;
		this.info_mc.logo_mc.onPress = TopNavUI.prototype.openLink;
		this.info_mc.body_txt.html = true;
	}
	this.info_mc.obscurer_mc.onPress = TopNavUI.prototype.obscurerCallback;
	this.info_mc.obscurer_mc.useHandCursor = false;
	this.info_mc.head_txt.text = info.HEAD_str;
	this.info_mc.body_txt.htmlText = info.BODY_HTML_str;
	var logoFrameLabel = (info.logoFrameLabel != null) ? info.logoFrameLabel : "blank";
	this.info_mc.logo_mc.gotoAndStop(logoFrameLabel);
	this.info_mc.logo_mc.url = info.url;
	this.info_mc._visible = true;
}

//----------------------------------------------------------------------
// hideInfo
//----------------------------------------------------------------------
TopNavUI.prototype.hideInfo = function()
{
	// Restore tab indices to pre info box state.
	_global.tabController.setActiveTabs(this.activeTabs);
	this.activeTabs = undefined;
	this.info_mc._visible = false;
}

//----------------------------------------------------------------------
// homeBtnCallback
//
// Special case call back for the home button.
//----------------------------------------------------------------------
TopNavUI.prototype.homeBtnCallback = function(btn_ib)
{
	if(this.currentBtn != null){ // Info Display is open
			this.currentBtn.setIcon("topNavBtnIcon_mc");
			this.currentBtn = null;
			this.hideInfo();
	}
	_global.goHome();
}

//----------------------------------------------------------------------
// obscurerCallback
//----------------------------------------------------------------------
TopNavUI.prototype.obscurerCallback = function()
{
	this.controller.infoBtnCallback(this.controller.currentBtn);
}

//----------------------------------------------------------------------
// setBtnSpacing
//----------------------------------------------------------------------
TopNavUI.prototype.setBtnSpacing = function(btnSpacing)
{
	this.btnSpacing = btnSpacing;
}

//----------------------------------------------------------------------
// getBtnSpacing
//----------------------------------------------------------------------
TopNavUI.prototype.getBtnSpacing = function()
{
	return this.btnSpacing;
}

//----------------------------------------------------------------------
// openLink
//----------------------------------------------------------------------
TopNavUI.prototype.openLink = function(logo_mc)
{
	getURL(this.url, "_blank");
}

//----------------------------------------------------------------------
// initTabs
//
// Initialize the tab indexes for the top nav buttons.
//----------------------------------------------------------------------
TopNavUI.prototype.initTabs = function(tabController)
{
	var tabCt = TabConstants.prototype.TopNavUIStartTab;
	this.tabController = tabController;
	var btnLastIndex = this.btn_array.length - 1;
	for (i = btnLastIndex; i >= 0; i--){
		this.tabController.setTab("TopNavUI", this.btn_array[i], tabCt++);
	}
}

//----------------------------------------------------------------------
// reset
//
// Close any open info_mcs and reset the topNav UI.
//----------------------------------------------------------------------
TopNavUI.prototype.reset = function()
{
	if(this.currentBtn != null){
		this.currentBtn.setIcon("topNavBtnIcon_mc");
		this.currentBtn = null;
		this.hideInfo();
	}
}

#endinitclip

//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
