// Copyright 2002 Macromedia, Inc. and its licensors.  All Rights Reserved.
//
// Use and/or redistribution of this file, in whole or in part, is subject
// to the Macromedia Sample Files License, which was distributed with this file.
//
#initclip 
//
//
/*
//
BillingFieldsUI class

	The BillingFieldsUI class encapsulates all UI behavior of the BillingFields
	section of the checkout.

	This code is meant to initialize the section and provide uniform access
	to the BillingFields data object.

	This file is associated with a library movie clip symbol.

	#include info for this file:

			FLA:				main.fla

			Layer:				Actions : Class

			Frame:				1

			Library Symbol:		BillingFldsOpenContent_mc

			Library Path:		CheckoutWidget/billingFlds/billingFldsOpenContent_mc
//
*/
//

//----------------------------------------------------------------------
//BillingFieldsUI
//
// As with all the CheckoutUI classes, this class encapsulates the 
// behaviour of the "open" state of this checkout widget.
//
// The "closed" state of this widget can be referenced via:
//
// 	this._parent.summaryContent_mc
//
//
//----------------------------------------------------------------------
function BillingFieldsUI() {
}

// Associate the BillingFieldsUI class with the authortime 
// billingFldsOpenContent_mc instance
Object.registerClass("BillingFieldsUISymbol", BillingFieldsUI);

BillingFieldsUI.prototype = new MovieClip();

//----------------------------------------------------------------------
// init
//----------------------------------------------------------------------
BillingFieldsUI.prototype.init = function(tabController, firstTab, strings, checkout) {
	this.checkout = checkout;
	var tabCount = firstTab;
	this.hint_txt.text = strings.BILLING_FLDS_HINT_str;
	this.useBillingForShipping_ch.setLabel(strings.USE_THIS_FOR_SHIPPING_CH_LBL_str);
	this.useBillingForShipping_ch.controller = this;
	tabController.setTab("BillingFieldsUI", this.firstNameFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.lastNameFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.country_cb, tabCount++);
	tabController.setTab("BillingFieldsUI", this.addressFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.cityFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.state_cb, tabCount++);
	tabController.setTab("BillingFieldsUI", this.zipCodeFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.phoneFld_mc.input_txt, tabCount++);
	tabController.setTab("BillingFieldsUI", this.useBillingForShipping_ch, tabCount++);
	tabController.setTab("BillingFieldsUI", this.continue_ib, tabCount++);
	checkout.applyAddressFldLabels(this);
	_global.sizeAndFormatIconBtn(this.continue_ib, strings.CONTINUE_BTN_LBL_str, _global.formIconBtnFormat);
}


//----------------------------------------------------------------------
// copyToSummary
//
// 	This function is called after the widget's been validated and is
// 	collapsing.
//----------------------------------------------------------------------
BillingFieldsUI.prototype.copyToSummary = function()
{
	var summaryMsg_str = this.firstNameFld_mc.input_txt.text + " " +  this.lastNameFld_mc.input_txt.text + newline;
	summaryMsg_str += this.addressFld_mc.input_txt.text + newline;
	summaryMsg_str += this.cityFld_mc.input_txt.text + ", " + this.state_cb.getValue() + "  " + this.country_cb.getValue() + "  " + this.zipCodeFld_mc.input_txt.text + newline;
	summaryMsg_str += this.phoneFld_mc.input_txt.text;
	this._parent.summaryContent_mc.summary_txt.text = summaryMsg_str;
}

//----------------------------------------------------------------------
// opening
//
// 	This function is called when the UI widget is opening.
//----------------------------------------------------------------------
BillingFieldsUI.prototype.opening = function() {
	Selection.setFocus(this.firstNameFld_mc.input_txt);
}

//----------------------------------------------------------------------
// validate
//
// 	Because billing fields and shipping fields validate identically,
// 	the code is shared in the checkout class.
//----------------------------------------------------------------------
BillingFieldsUI.prototype.validate = function() {
	return this.checkout.validateAddresses(this);
}

#endinitclip 
//Authors: Brian Kruse (bkruse), Buck Bito (bbito)
