package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.SubtractExp;
import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class SubtractExpTest extends TestCase {

    public SubtractExpTest(String name) {
        super(name);
    }

    public void testSubtract() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	IntegerExp i2Con = new IntegerExp(new Integer(2));
    	SubtractExp exp = new SubtractExp(i1Con, i2Con);
        assertEquals("1", new Integer(-1), exp.evaluateValue(null));
    }
    
    public void testSubtract2() throws Exception {
    	ToLongExp toLong1Exp = new ToLongExp(new StringExp("1"), null);
    	ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
    	SubtractExp exp = new SubtractExp(toLong1Exp, toLong2Exp);
        assertEquals("1", new Long(-1), exp.evaluateValue(null));
    }
    
    public void testSubtract3() throws Exception {
    	DoubleExp double1Exp = new DoubleExp(new Double(1));
    	DoubleExp double2Exp = new DoubleExp(new Double(2));
    	SubtractExp exp = new SubtractExp(double1Exp, double2Exp);
        assertEquals("1", new Double(-1), exp.evaluateValue(null));
    }
    
    public void testSubtract4() throws Exception {
    	IntegerExp i1Con = new IntegerExp(new Integer(1));
    	SubtractExp exp = new SubtractExp(i1Con, new NullExp());
        assertEquals("1", null, exp.evaluateValue(null));
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(SubtractExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{SubtractExpTest.class.getName()});
    }
}