package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.MultiplyExp;
import org.seasar.nazuna.NullExp;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class MultiplyExpTest extends TestCase {

	public MultiplyExpTest(String name) {
		super(name);
	}

	public void testMultiply() throws Exception {
		IntegerExp i1Con = new IntegerExp(new Integer(2));
		IntegerExp i2Con = new IntegerExp(new Integer(3));
		MultiplyExp exp = new MultiplyExp(i1Con, i2Con);
		assertEquals("1", new Integer(6), exp.evaluateValue(null));
	}

	public void testMultiply2() throws Exception {
		ToLongExp toLong1Exp = new ToLongExp(new StringExp("2"), null);
		ToLongExp toLong2Exp = new ToLongExp(new StringExp("3"), null);
		MultiplyExp exp = new MultiplyExp(toLong1Exp, toLong2Exp);
		assertEquals("1", new Long(6), exp.evaluateValue(null));
	}

	public void testMultiply3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(2));
		DoubleExp double2Exp = new DoubleExp(new Double(3));
		MultiplyExp exp = new MultiplyExp(double1Exp, double2Exp);
		assertEquals("1", new Double(6), exp.evaluateValue(null));
	}

	public void testMultiply4() throws Exception {
		IntegerExp i1Con = new IntegerExp(new Integer(1));
		MultiplyExp exp = new MultiplyExp(i1Con, new NullExp());
		assertEquals("1", null, exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MultiplyExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { MultiplyExpTest.class.getName()});
	}
}