package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.ModExp;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class ModExpTest extends TestCase {

	public ModExpTest(String name) {
		super(name);
	}

	public void testMod() throws Exception {
		IntegerExp i1Con = new IntegerExp(new Integer(5));
		IntegerExp i2Con = new IntegerExp(new Integer(2));
		ModExp exp = new ModExp(i1Con, i2Con);
		assertEquals("1", new Integer(1), exp.evaluateValue(null));
	}

	public void testMod2() throws Exception {
		ToLongExp toLong1Exp = new ToLongExp(new StringExp("5"), null);
		ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
		ModExp exp = new ModExp(toLong1Exp, toLong2Exp);
		assertEquals("1", new Long(1), exp.evaluateValue(null));
	}

	public void testMod3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(5));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		ModExp exp = new ModExp(double1Exp, double2Exp);
		assertEquals("1", new Double(1), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(ModExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { ModExpTest.class.getName()});
	}
}