package test.org.seasar.nazuna;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.DivideExp;
import org.seasar.nazuna.DoubleExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.StringExp;
import org.seasar.nazuna.ToLongExp;

public class DivideExpTest extends TestCase {

	public DivideExpTest(String name) {
		super(name);
	}

	public void testDivide() throws Exception {
		IntegerExp i1Con = new IntegerExp(new Integer(5));
		IntegerExp i2Con = new IntegerExp(new Integer(2));
		DivideExp exp = new DivideExp(i1Con, i2Con);
		assertEquals("1", new Integer(2), exp.evaluateValue(null));
	}

	public void testDivide2() throws Exception {
		ToLongExp toLong1Exp = new ToLongExp(new StringExp("5"), null);
		ToLongExp toLong2Exp = new ToLongExp(new StringExp("2"), null);
		DivideExp exp = new DivideExp(toLong1Exp, toLong2Exp);
		assertEquals("1", new Long(2), exp.evaluateValue(null));
	}

	public void testDivide3() throws Exception {
		DoubleExp double1Exp = new DoubleExp(new Double(5));
		DoubleExp double2Exp = new DoubleExp(new Double(2));
		DivideExp exp = new DivideExp(double1Exp, double2Exp);
		assertEquals("1", new Double(2.5), exp.evaluateValue(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(DivideExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { DivideExpTest.class.getName()});
	}
}