package org.seasar.nazuna;

import java.lang.reflect.Array;
import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SetArrayVariableExp implements Expression {

	private String _name;
	private Expression _indexExp;
	private Expression _argExp;
	
    public SetArrayVariableExp(final String name, final Expression indexExp,
    		final Expression argExp) {
    		
    	Assertion.assertNotNull("name", name);
		Assertion.assertNotNull("indexExp", indexExp);
    	Assertion.assertNotNull("argExp", argExp);
    		
        _name = name;
        _indexExp = indexExp;
        _argExp = argExp;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
		Number indexNum = (Number) _indexExp.evaluateValue(ruleContext);
		int index = indexNum.intValue();
    	Object arg = _argExp.evaluateValue(ruleContext);
    	Object array = ruleContext.getValue(_name);
    	if (array instanceof List) {
    		((List) array).set(index, arg);
    	} else {
			Array.set(array, index, arg);
    	}
    	return arg;
    }
}
