package org.seasar.nazuna;

import java.util.List;
import java.util.Map;

import org.seasar.util.ArrayUtil;
import org.seasar.util.SeasarException;

public final class NazunaService implements NazunaServiceMBean {

	public NazunaService() {
	}

	public final Object executeRulet(String className) throws SeasarException {

		return executeRulet(className, ArrayUtil.EMPTY_OBJECTS);
	}

	public final Object executeRulet(String className, Object arg0)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0 });
	}

	public final Object executeRulet(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1 });
	}

	public final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1, arg2 });
	}

	public final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeRulet(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final Object executeRulet(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeRulet(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final Object executeRulet(String className, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeRulet(className, args);
	}

	public final Object execute(final String name) throws SeasarException {
		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.execute(name, (Map) null);
	}

	public final Object execute(final String name, final Map parameters)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.execute(name, parameters);
	}

	public final Object execute(String className, Object arg0)
		throws SeasarException {

		return execute(className, new Object[] { arg0 });
	}

	public final Object execute(String className, Object arg0, Object arg1)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1 });
	}

	public final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1, arg2 });
	}

	public final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return execute(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final Object execute(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return execute(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final Object execute(String name, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.execute(name, args);
	}

	public final List executeQuery(final String name) throws SeasarException {
		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeQuery(name, (Map) null);
	}

	public final List executeQuery(final String name, final Map parameters)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeQuery(name, parameters);
	}

	public final List executeQuery(String className, Object arg0)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0 });
	}

	public final List executeQuery(String className, Object arg0, Object arg1)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1 });
	}

	public final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeQuery(className, new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final List executeQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final List executeQuery(String name, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeQuery(name, args);
	}

	public final Object executeSingleQuery(final String name)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeSingleQuery(name, (Map) null);
	}

	public final Object executeSingleQuery(
		final String name,
		final Map parameters)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeQuery(name, parameters);
	}

	public final Object executeSingleQuery(String className, Object arg0)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0 });
	}

	public final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0, arg1 });
	}

	public final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeSingleQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeSingleQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final Object executeSingleQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeSingleQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final Object executeSingleQuery(String name, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocationByRuleName(name);
		return loc.executeSingleQuery(name, args);
	}

	public final NzRecordSet executeRSQuery(final String name)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeRSQuery(name, (Map) null);
	}

	public final NzRecordSet executeRSQuery(
		final String name,
		final Map parameters)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeRSQuery(name, parameters);
	}

	public final NzRecordSet executeRSQuery(String className, Object arg0)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0 });
	}

	public final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0, arg1 });
	}

	public final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeRSQuery(className, new Object[] { arg0, arg1, arg2 });
	}

	public final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeRSQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final NzRecordSet executeRSQuery(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeRSQuery(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final NzRecordSet executeRSQuery(String name, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeRSQuery(name, args);
	}

	public final int executeUpdate(final String name) throws SeasarException {
		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeUpdate(name, (Map) null);
	}

	public final int executeUpdate(final String name, final Map parameters)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeUpdate(name, parameters);
	}

	public final int executeUpdate(String className, Object arg0)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0 });
	}

	public final int executeUpdate(String className, Object arg0, Object arg1)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0, arg1 });
	}

	public final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2)
		throws SeasarException {

		return executeUpdate(className, new Object[] { arg0, arg1, arg2 });
	}

	public final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3)
		throws SeasarException {

		return executeUpdate(
			className,
			new Object[] { arg0, arg1, arg2, arg3 });
	}

	public final int executeUpdate(
		String className,
		Object arg0,
		Object arg1,
		Object arg2,
		Object arg3,
		Object arg4)
		throws SeasarException {

		return executeUpdate(
			className,
			new Object[] { arg0, arg1, arg2, arg3, arg4 });
	}

	public final int executeUpdate(String name, Object[] args)
		throws SeasarException {

		NazunaLocation loc = NazunaRemoting.getLocalLocation();
		return loc.executeUpdate(name, args);
	}

	public final void start() throws SeasarException {
	}

	public final void stop() throws SeasarException {
		RuletContainer.destroyAll();
	}

}
