package org.seasar.nazuna;

import java.lang.reflect.Array;
import java.util.List;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class GetArrayVariableExp implements Expression {

	private String _name;
	private Expression _indexExp;
	
    public GetArrayVariableExp(final String name, final Expression indexExp) {
    	Assertion.assertNotNull("name", name);
		Assertion.assertNotNull("indexExp", indexExp);
    	
        _name = name;
        _indexExp = indexExp;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
		Number indexNum = (Number) _indexExp.evaluateValue(ruleContext);
		int index = indexNum.intValue();
    	Object array = ruleContext.getValue(_name);
		if (array instanceof List) {
			return ((List) array).get(index);
		} else {
			return Array.get(array, index);
		}
    }
}
