package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.MathUtil;
import org.seasar.util.SeasarException;

public final class DivideExp implements Expression {

	private final Expression _arg1Exp;
	private final Expression _arg2Exp;

	public DivideExp(final Expression arg1Exp, final Expression arg2Exp) {
		Assertion.assertNotNull("arg1Exp", arg1Exp);
		Assertion.assertNotNull("arg2Exp", arg2Exp);

		_arg1Exp = arg1Exp;
		_arg2Exp = arg2Exp;
	}

	public Object evaluateValue(final RuleContext ruleContext)
		throws SeasarException {

		Number arg1 = (Number) _arg1Exp.evaluateValue(ruleContext);
		Number arg2 = (Number) _arg2Exp.evaluateValue(ruleContext);
		return MathUtil.divide(arg1, arg2);
	}
}