CREATE TABLE EMP
       (EMPNO NUMERIC(4) NOT NULL PRIMARY KEY,
        ENAME VARCHAR(10),
        JOB VARCHAR(9),
        MGR NUMERIC(4),
        HIREDATE DATE,
        SAL NUMERIC(7, 2),
        COMM NUMERIC(7, 2),
        DEPTNO NUMERIC(2));

INSERT INTO EMP VALUES (7369, 'SMITH',  'CLERK',     7902,
        '1980-12-17',  800, NULL, 20);
INSERT INTO EMP VALUES (7499, 'ALLEN',  'SALESMAN',  7698,
        '1981-02-20', 1600,  300, 30);
INSERT INTO EMP VALUES (7521, 'WARD',   'SALESMAN',  7698,
        '1981-02-22', 1250,  500, 30);
INSERT INTO EMP VALUES (7566, 'JONES',  'MANAGER',   7839,
        '1981-04-02',  2975, NULL, 20);
INSERT INTO EMP VALUES (7654, 'MARTIN', 'SALESMAN',  7698,
        '1981-09-28', 1250, 1400, 30);
INSERT INTO EMP VALUES (7698, 'BLAKE',  'MANAGER',   7839,
        '1981-05-01',  2850, NULL, 30);
INSERT INTO EMP VALUES (7782, 'CLARK',  'MANAGER',   7839,
        '1981-06-09',  2450, NULL, 10);
INSERT INTO EMP VALUES (7788, 'SCOTT',  'ANALYST',   7566,
        '1982-12-09', 3000, NULL, 20);
INSERT INTO EMP VALUES (7839, 'KING',   'PRESIDENT', NULL,
        '1981-11-17', 5000, NULL, 10);
INSERT INTO EMP VALUES (7844, 'TURNER', 'SALESMAN',  7698,
        '1981-09-08',  1500,    0, 30);
INSERT INTO EMP VALUES (7876, 'ADAMS',  'CLERK',     7788,
        '1983-01-12', 1100, NULL, 20);
INSERT INTO EMP VALUES (7900, 'JAMES',  'CLERK',     7698,
        '1981-12-03',   950, NULL, 30);
INSERT INTO EMP VALUES (7902, 'FORD',   'ANALYST',   7566,
        '1981-12-03',  3000, NULL, 20);
INSERT INTO EMP VALUES (7934, 'MILLER', 'CLERK',     7782,
        '1982-01-23', 1300, NULL, 10);

CREATE TABLE DEPT
       (DEPTNO NUMERIC(2) NOT NULL PRIMARY KEY,
        DNAME VARCHAR(14),
        LOC VARCHAR(13));

INSERT INTO DEPT VALUES (10, 'ACCOUNTING', 'NEW YORK');
INSERT INTO DEPT VALUES (20, 'RESEARCH',   'DALLAS');
INSERT INTO DEPT VALUES (30, 'SALES',      'CHICAGO');
INSERT INTO DEPT VALUES (40, 'OPERATIONS', 'BOSTON');

CREATE TABLE ADDRESS
       (USEROID INTEGER NOT NULL,
        ADDRESSTYPE INTEGER NOT NULL,
        FIRSTNAME VARCHAR,
        LASTNAME VARCHAR,
        STREET1 VARCHAR,
        STREET2 VARCHAR,
        CITY VARCHAR,
        STATE VARCHAR,
        COUNTRY VARCHAR,
        ZIPCODE VARCHAR,
        CONSTRAINT SYS_PK_ADDRESS PRIMARY KEY
        (USEROID, ADDRESSTYPE));

INSERT INTO ADDRESS VALUES(0, 1, NULL, NULL, 'ccc', NULL,
        'ddd', 'AR', 'USA', '11111');
INSERT INTO ADDRESS VALUES(0, 2, NULL, NULL, 'ccc', NULL,
        'ddd', 'AR', 'USA', '11111');

CREATE TABLE CATEGORY
       (CATEGORYOID INTEGER NOT NULL PRIMARY KEY,
        CATEGORYDISPLAYNAME VARCHAR,
        CATEGORYNAME VARCHAR,
        COLOR VARCHAR, LOCALE VARCHAR);

INSERT INTO CATEGORY VALUES(1, 'fish',     'fish',
        '4F9FDB', 'en_US');
INSERT INTO CATEGORY VALUES(2, 'dogs',     'dogs',
        'FF876F', 'en_US');
INSERT INTO CATEGORY VALUES(3, 'reptiles', 'reptiles',
        '97D76B', 'en_US');
INSERT INTO CATEGORY VALUES(4, 'cats',     'cats',
        'FFA672', 'en_US');
INSERT INTO CATEGORY VALUES(5, 'birds',    'birds',
        'D7A91E', 'en_US');

CREATE TABLE CREDITCARD
       (USEROID INTEGER NOT NULL PRIMARY KEY,
        CREDITCARDNUMBER VARCHAR,
        CREDITCARDTYPE VARCHAR,
        CREDITCARDEXPIRY TIMESTAMP);

INSERT INTO CREDITCARD VALUES(0, NULL, NULL, NULL);

CREATE TABLE ITEM
       (ITEMOID INTEGER NOT NULL PRIMARY KEY,
        ITEMID VARCHAR,
        ITEMNAME VARCHAR,
        QUANTITY VARCHAR,
        PRODUCTOID INTEGER,
        LISTPRICE NUMERIC(19, 4),
        DESCRIPTION LONGVARCHAR);

INSERT INTO ITEM VALUES(200, 'EST-73',  'Medium Male',
        '11', 96,  2.0000,
        'Nice choice!  A male medium Goldfish will make a great pet for you.');
INSERT INTO ITEM VALUES(201, 'EST-74',  'Medium Female',
        '0',  96,  2.0000,
        'Nice choice!  A female medium Goldfish will make a great pet for you.');
INSERT INTO ITEM VALUES(202, 'EST-75',  'Large Male',
        '6',  96,  3.0000,
        'Nice choice!  A male large Goldfish will make a great pet for you.  Double click or drag this item to your cart');
INSERT INTO ITEM VALUES(203, 'EST-76',  'Large Female',
        '10', 96,  3.0000,
        'Nice choice!  A female large Goldfish will make a great pet for you.');
INSERT INTO ITEM VALUES(204, 'EST-77',  'Small Male',
        '14', 102, 30.0000,
        'Nice choice!  A male small Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(205, 'EST-78',  'Small Female',
        '6',  102, 30.0000,
        'Nice choice!  A female small Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(206, 'EST-79',  'Medium Male',
        '9',  102, 50.0000,
        'Nice choice!  A male medium Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(207, 'EST-80',  'Medium Female',
        '8',  102, 50.0000,
        'Nice choice!  A female medium Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(208, 'EST-81',  'Large Male',
        '9',  102, 120.0000,
        'Nice choice!  A male large Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(209, 'EST-82',  'Large Female',
        '8',  102, 120.0000,
        'Nice choice!  A female large Koi will make a great pet for you.');
INSERT INTO ITEM VALUES(210, 'EST-83',  'Small Male',
        '4',  108, 20.0000,
        'Nice choice!  A male small Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(211, 'EST-84',  'Small Female',
        '7',  108, 20.0000,
        'Nice choice!  A female small Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(212, 'EST-85',  'Medium Male',
        '12', 108, 25.0000,
        'Nice choice!  A male medium Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(213, 'EST-86',  'Medium Female',
        '9',  108, 25.0000,
        'Nice choice!  A female medium Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(214, 'EST-87',  'Large Male',
        '14', 108, 50.0000,
        'Nice choice!  A male large Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(215, 'EST-88',  'Large Female',
        '13', 108, 50.0000,
        'Nice choice!  A female large Hippo Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(216, 'EST-89',  'Small Male',
        '7',  114, 17.0000,
        'Nice choice!  A male small Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(217, 'EST-90',  'Small Female',
        '2',  114, 17.0000,
        'Nice choice!  A female small Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(218, 'EST-91',  'Medium Male',
        '5',  114, 25.0000,
        'Nice choice!  A male medium Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(219, 'EST-92',  'Medium Female',
        '5',  114, 25.0000,
        'Nice choice!  A female medium Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(220, 'EST-93',  'Large Male',
        '2',  114, 40.0000,
        'Nice choice!  A male large Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(221, 'EST-94',  'Large Female',
        '5',  114, 40.0000,
        'Nice choice!  A female large Yellow Sailfin Tang will make a great pet for you.');
INSERT INTO ITEM VALUES(222, 'EST-95',  'Small Male',
        '4',  120, 10.0000,
        'Nice choice!  A male small Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(223, 'EST-96',  'Small Female',
        '6',  120, 10.0000,
        'Nice choice!  A female small Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(224, 'EST-97',  'Medium Male',
        '7',  120, 15.0000,
        'Nice choice!  A male medium Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(225, 'EST-98',  'Medium Female',
        '9',  120, 15.0000,
        'Nice choice!  A female medium Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(226, 'EST-99',  'Large Male',
        '2',  120, 25.0000,
        'Nice choice!  A male large Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(227, 'EST-100', 'Large Female',
        '2',  120, 25.0000,
        'Nice choice!  A female large Clown Fish will make a great pet for you.');
INSERT INTO ITEM VALUES(228, 'EST-101', 'Small Male',
        '10', 126, 50.0000,
        'Nice choice!  A male baby Chameleon will make a great pet for you.');
INSERT INTO ITEM VALUES(229, 'EST-102', 'Small Female',
        '3',  126, 50.0000,
        'Nice choice!  A female baby Chameleon will make a great pet for you.');
INSERT INTO ITEM VALUES(230, 'EST-103', 'Large Male',
        '1',  126, 70.0000,
        'Nice choice!  A male adult Chameleon will make a great pet for you.');
INSERT INTO ITEM VALUES(231, 'EST-104', 'Large Female',
        '10', 126, 70.0000,
        'Nice choice!  A female large Chameleon will make a great pet for you.');
INSERT INTO ITEM VALUES(232, 'EST-105', 'Small Male',
        '8',  130, 13.0000,
        'Nice choice!  A male small Iguana will make a great pet for you.');
INSERT INTO ITEM VALUES(233, 'EST-106', 'Small Female',
        '0',  130, 13.0000,
        'Nice choice!  A female small Iguana will make a great pet for you.');
INSERT INTO ITEM VALUES(234, 'EST-107', 'Large Male',
        '11', 130, 20.0000,
        'Nice choice!  A male large Iguana will make a great pet for you.');
INSERT INTO ITEM VALUES(235, 'EST-108', 'Large Female',
        '9',  130, 20.0000,
        'Nice choice!  A female large Iguana will make a great pet for you.');
INSERT INTO ITEM VALUES(236, 'EST-109', 'Small Male',
        '3',  134, 95.0000,
        'Nice choice!  A male small Gecko will make a great pet for you.');
INSERT INTO ITEM VALUES(237, 'EST-110', 'Small Female',
        '10', 134, 95.0000,
        'Nice choice!  A female small Gecko will make a great pet for you.');
INSERT INTO ITEM VALUES(238, 'EST-111', 'Large Male',
        '6',  134, 200.0000,
        'Nice choice!  A male large Gecko will make a great pet for you.');
INSERT INTO ITEM VALUES(239, 'EST-112', 'Large Female',
        '8',  134, 200.0000,
        'Nice choice!  A female large Gecko will make a great pet for you.');
INSERT INTO ITEM VALUES(240, 'EST-113', 'Small Male',
        '10', 138, 40.0000,
        'Nice choice!  A male small Milk Snake will make a great pet for you.');
INSERT INTO ITEM VALUES(241, 'EST-114', 'Small Female',
        '0',  138, 40.0000,
        'Nice choice!  A female small Milk Snake will make a great pet for you.');
INSERT INTO ITEM VALUES(242, 'EST-115', 'Large Male',
        '1',  138, 90.0000,
        'Nice choice!  A male large Milk Snake will make a great pet for you.');
INSERT INTO ITEM VALUES(243, 'EST-116', 'Large Female',
        '8',  138, 90.0000,
        'Nice choice!  A female large Milk Snake will make a great pet for you.');
INSERT INTO ITEM VALUES(244, 'EST-117', 'Small Male',
        '13', 142, 20.0000,
        'Nice choice!  A male small Turtle will make a great pet for you.');
INSERT INTO ITEM VALUES(245, 'EST-118', 'Small Female',
        '8',  142, 20.0000,
        'Nice choice!  A female small Turtle will make a great pet for you.');
INSERT INTO ITEM VALUES(246, 'EST-119', 'Large Male',
        '6',  142, 35.0000,
        'Nice choice!  A male large Turtle will make a great pet for you.');
INSERT INTO ITEM VALUES(247, 'EST-120', 'Large Female',
        '2',  142, 35.0000,
        'Nice choice!  A female large Turtle will make a great pet for you.');
INSERT INTO ITEM VALUES(252, 'EST-1',   'Male Adult',
        '12', 26,  50.0000,
        'Nice choice!  A male adult Cocker Spaniel will make a great pet for you.');
INSERT INTO ITEM VALUES(253, 'EST-2',   'Female Adult',
        '2',  26,  75.0000,
        'Nice choice!  A female adult Cocker Spaniel will make a great pet for you.');
INSERT INTO ITEM VALUES(254, 'EST-3',   'Male Puppy',
        '1',  26,  200.0000,
        'Nice choice!  A male Cocker Spaniel puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(255, 'EST-4',   'Female Puppy',
        '15', 26,  250.0000,
        'Nice choice!  A female Cocker Spaniel puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(256, 'EST-5',   'Male Adult',
        '15', 30,  110.0000,
        'Nice choice!  A male adult Golden Retriever will make a great pet for you.');
INSERT INTO ITEM VALUES(257, 'EST-6',   'Female Adult',
        '4',  30,  130.0000,
        'Nice choice!  A female adult Golden Retriever will make a great pet for you.');
INSERT INTO ITEM VALUES(258, 'EST-7',   'Male Puppy',
        '13', 30,  350.0000,
        'Nice choice!  A male Golden Retriever puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(259, 'EST-8',   'Female Puppy',
        '5',  30,  400.0000,
        'Nice choice!  A female Golden Retriever puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(260, 'EST-9',   'Male Adult',
        '3',  34,  95.0000,
        'Nice choice!  A male adult Jack Russell Terrier will make a great pet for you.');
INSERT INTO ITEM VALUES(261, 'EST-11',  'Male Puppy',
        '9',  34,  450.0000,
        'Nice choice!  A male Jack Russell Terrier puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(262, 'EST-14',  'Female Adult',
        '11', 38,  120.0000,
        'Nice choice!  A female adult German Shepherd will make a great pet for you.?');
INSERT INTO ITEM VALUES(263, 'EST-16',  'Female Puppy',
        '6',  38,  800.0000,
        'Nice choice!  A female German Shepherd puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(264, 'EST-17',  'Male Adult',
        '11', 42,  200.0000,
        'Nice choice!  A male adult Dachshund will make a great pet for you.');
INSERT INTO ITEM VALUES(265, 'EST-18',  'Female Adult',
        '11', 42,  250.0000,
        'Nice choice!  A female adult Dachshund will make a great pet for you.?');
INSERT INTO ITEM VALUES(266, 'EST-19',  'Male Puppy',
        '7',  42,  300.0000,
        'Nice choice!  A male Dachshund puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(267, 'EST-20',  'Female Puppy',
        '15', 42,  350.0000,
        'Nice choice!  A female Dachshund puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(268, 'EST-21',  'Male Adult',
        '4',  46,  700.0000,
        'Nice choice!  A male adult Bulldog will make a great pet for you.');
INSERT INTO ITEM VALUES(269, 'EST-22',  'Female Adult',
        '3',  46,  800.0000,
        'Nice choice!  A female adult Bulldog will make a great pet for you.?');
INSERT INTO ITEM VALUES(270, 'EST-23',  'Male Puppy',
        '14', 46,  1110.0000,
        'Nice choice!  A male Bulldog puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(271, 'EST-24',  'Female Puppy',
        '4',  46,  1200.0000,
        'Nice choice!  A female Bulldog puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(272, 'EST-25',  'Male Adult',
        '13', 50,  85.0000,
        'Nice choice!  A male adult Dalmatian will make a great pet for you.');
INSERT INTO ITEM VALUES(273, 'EST-26',  'Female Adult',
        '3',  50,  100.0000,
        'Nice choice!  A female adult Dalmatian will make a great pet for you.?');
INSERT INTO ITEM VALUES(274, 'EST-27',  'Male Puppy',
        '1',  50,  275.0000,
        'Nice choice!  A male Dalmatian puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(275, 'EST-28',  'Female Puppy',
        '8',  50,  300.0000,
        'Nice choice!  A female Dalmatian puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(276, 'EST-29',  'Male Adult',
        '1',  54,  125.0000,
        'Nice choice!  A male adult Pembroke Welsh Corgi will make a great pet for you.');
INSERT INTO ITEM VALUES(277, 'EST-30',  'Female Adult',
        '14', 54,  150.0000,
        'Nice choice!  A female adult Pembroke Welsh Corgi will make a great pet for you.?');
INSERT INTO ITEM VALUES(278, 'EST-31',  'Male Puppy',
        '7',  54,  350.0000,
        'Nice choice!  A male Pembroke Welsh Corgi puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(279, 'EST-32',  'Female Puppy',
        '2',  54,  400.0000,
        'Nice choice!  A female Pembroke Welsh Corgi puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(280, 'EST-33',  'Male Adult',
        '13', 58,  150.0000,
        'Nice choice!  A male adult Bernese Mountain will make a great pet for you.');
INSERT INTO ITEM VALUES(281, 'EST-34',  'Female Adult',
        '14', 58,  200.0000,
        'Nice choice!  A female adult Bernese Mountain will make a great pet for you.?');
INSERT INTO ITEM VALUES(282, 'EST-35',  'Male Puppy',
        '10', 58,  600.0000,
        'Nice choice!  A male Bernese Mountain puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(283, 'EST-36',  'Female Puppy',
        '2',  58,  700.0000,
        'Nice choice!  A female Bernese Mountain puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(284, 'EST-37',  'Male Adult',
        '0',  62,  110.0000,
        'Nice choice!  A male adult Great Dane will make a great pet for you.');
INSERT INTO ITEM VALUES(285, 'EST-38',  'Female Adult',
        '2',  62,  130.0000,
        'Nice choice!  A female adult Great Dane will make a great pet for you.?');
INSERT INTO ITEM VALUES(286, 'EST-39',  'Male Puppy',
        '9',  62,  500.0000,
        'Nice choice!  A male Great Dane puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(287, 'EST-40',  'Female Puppy',
        '12', 62,  600.0000,
        'Nice choice!  A female Great Dane puppy will make a great pet for you.');
INSERT INTO ITEM VALUES(288, 'EST-41',  'Male Adult',
        '4',  66,  65.0000,
        'Nice choice!  An adult male American Wirehair will make a great pet for you.');
INSERT INTO ITEM VALUES(289, 'EST-42',  'Female Adult',
        '10', 66,  75.0000,
        'Nice choice!  An adult female American Wirehair will make a great pet for you.');
INSERT INTO ITEM VALUES(290, 'EST-43',  'Male Kitten',
        '4',  66,  90.0000,
        'Nice choice!  A male American Wirehair kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(291, 'EST-44',  'Female Kitten',
        '4',  66,  95.0000,
        'Nice choice!  A female American Wirehair kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(292, 'EST-45',  'Male Adult',
        '12', 70,  80.0000,
        'Nice choice!  An adult male Ragdoll will make a great pet for you.');
INSERT INTO ITEM VALUES(293, 'EST-46',  'Female Adult',
        '8',  70,  85.0000,
        'Nice choice!  An adult female Ragdoll will make a great pet for you.');
INSERT INTO ITEM VALUES(294, 'EST-47',  'Male Kitten',
        '4',  70,  110.0000,
        'Nice choice!  A male Ragdoll kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(295, 'EST-48',  'Female Kitten',
        '9',  70,  150.0000,
        'Nice choice!  A female Ragdoll kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(296, 'EST-49',  'Male Adult',
        '2',  74,  100.0000,
        'Nice choice!  An adult male Persian will make a great pet for you.');
INSERT INTO ITEM VALUES(297, 'EST-50',  'Female Adult',
        '1',  74,  125.0000,
        'Nice choice!  An adult female Persian will make a great pet for you.');
INSERT INTO ITEM VALUES(298, 'EST-51',  'Male Kitten',
        '9',  74,  400.0000,
        'Nice choice!  A male Persian kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(299, 'EST-52',  'Female Kitten',
        '13', 74,  425.0000,
        'Nice choice!  A female Persian kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(300, 'EST-53',  'Male Adult',
        '9',  78,  55.0000,
        'Nice choice!  An adult male American Shorthair will make a great pet for you.');
INSERT INTO ITEM VALUES(301, 'EST-54',  'Female Adult',
        '2',  78,  55.0000,
        'Nice choice!  An adult female American Shorthair will make a great pet for you.');
INSERT INTO ITEM VALUES(302, 'EST-55',  'Male Kitten',
        '8',  78,  95.0000,
        'Nice choice!  A male American Shorthair kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(303, 'EST-56',  'Female Kitten',
        '10', 78,  95.0000,
        'Nice choice!  A female American Shorthair kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(304, 'EST-57',  'Male Adult',
        '4',  82,  60.0000,
        'Nice choice!  An adult male Siamese will make a great pet for you.');
INSERT INTO ITEM VALUES(305, 'EST-58',  'Female Adult',
        '7',  82,  75.0000,
        'Nice choice!  An adult female Siamese will make a great pet for you.');
INSERT INTO ITEM VALUES(306, 'EST-59',  'Male Kitten',
        '15', 82,  110.0000,
        'Nice choice!  A male Siamese kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(307, 'EST-60',  'Female Kitten',
        '5',  82,  150.0000,
        'Nice choice!  A female Siamese kitten will make a great pet for you.');
INSERT INTO ITEM VALUES(308, 'EST-61',  'Male',
        '11', 86,  30.0000,
        'Nice choice!  A male Finch will make a great pet for you.');
INSERT INTO ITEM VALUES(309, 'EST-62',  'Female',
        '13', 86,  30.0000,
        'Nice choice!  A female Finch will make a great pet for you.');
INSERT INTO ITEM VALUES(310, 'EST-63',  'Male',
        '4',  88,  20.0000,
        'Nice choice!  A male Budgerigar will make a great pet for you.');
INSERT INTO ITEM VALUES(311, 'EST-64',  'Female',
        '4',  88,  20.0000,
        'Nice choice!  A female Budgerigar will make a great pet for you.');
INSERT INTO ITEM VALUES(312, 'EST-65',  'Male',
        '12', 90,  1400.0000,
        'Nice choice!  A male Macaw will make a great pet for you.');
INSERT INTO ITEM VALUES(313, 'EST-66',  'Female',
        '8',  90,  1500.0000,
        'Nice choice!  A female Macaw will make a great pet for you.');
INSERT INTO ITEM VALUES(314, 'EST-67',  'Male',
        '4',  92,  800.0000,
        'Nice choice!  A male Red-lored Amazon Parrot will make a great pet for you.');
INSERT INTO ITEM VALUES(315, 'EST-68',  'Female',
        '0',  92,  950.0000,
        'Nice choice!  A female Red-lored Amazon Parrot will make a great pet for you.');
INSERT INTO ITEM VALUES(316, 'EST-69',  'Male',
        '12', 94,  600.0000,
        'Nice choice!  A male Yellow-Naped Amazon Parrot will make a great pet for you.');
INSERT INTO ITEM VALUES(317, 'EST-70',  'Female',
        '6',  94,  650.0000,
        'Nice choice!  A female Yellow-Naped Amazon Parrot will make a great pet for you.');
INSERT INTO ITEM VALUES(318, 'EST-71',  'Small Male',
        '11', 96,  0.9500,
        'Nice choice!  A male small Goldfish will make a great pet for you.');
INSERT INTO ITEM VALUES(319, 'EST-72',  'Small Female',
        '4',  96,  1.3500,
        'Nice choice!  A female small Goldfish will make a great pet for you.');

CREATE TABLE ITEMLIST
       (CARTOID INTEGER NOT NULL,
        ITEMOID INTEGER NOT NULL,
        ITEMLISTSELECTION INTEGER,
        ITEMQUANTITY INTEGER,
        CONSTRAINT SYS_PK_ITEMLIST PRIMARY KEY
        (CARTOID, ITEMOID));

CREATE TABLE PRODUCT
       (PRODUCTOID INTEGER NOT NULL PRIMARY KEY,
        PRODUCTID VARCHAR,
        CATEGORYOID INTEGER,
        NAME VARCHAR,
        IMAGE VARCHAR,
        DESCRIPTION LONGVARCHAR,
        LOCALE VARCHAR);

CREATE INDEX PRODUCT_I1 ON PRODUCT(CATEGORYOID);

INSERT INTO PRODUCT VALUES(26,  'DG-CS-01', 2,
        'American Cocker Spaniel',    'DG-CS-01.jpg',
        'Charming and affectionate, this gentle, silky-coated companion is equally at home as pet or gundog, and is an inseparable friend of children. Cockers are fairly easy to train, and do well with other animals. Moderately active, a small yard is fine.',
        'en_US');
INSERT INTO PRODUCT VALUES(30,  'DG-GR-01', 2,
        'Golden Retriever',           'DG-GR-01.jpg',
        'Relaxed but responsive, the versatile, easy-to-train Golden is an ideal family companion and sporting dog, and is most happy around people. Moderately active, they do best with at least a medium sized yard.',
        'en_US');
INSERT INTO PRODUCT VALUES(34,  'DG-JR-01', 2,
        'Jack Russell Terrier',       'DG-JR-01.jpg',
        'Perky, merry, intelligent and loving, this dog is absolutely fearless- a BIG dog in a little dog body. A strong hunting instinct means they chase, explore, bark and dig. Firm training, terrier experience suggested. Very active indoors and out.',
        'en_US');
INSERT INTO PRODUCT VALUES(38,  'DG-GS-01', 2,
        'German Shepherd',            'DG-GS-01.jpg',
        'Handsome and strong, often used as a working dog, this breed is known for courage and loyalty to family. While wary of strangers, they only bark when necessary. They learn quickly, and are almost human in intelligence. They do best with a large yard. ',
        'en_US');
INSERT INTO PRODUCT VALUES(42,  'DG-DH-01', 2,
        'Dachshund',                  'DG-DH-01.jpg',
        'Lively and affectionate, this clever dog may try to train the owner! Curious, mischievous, but very devoted to family, they do best with older kids. They are fairly active indoors, but do OK without a yard.',
        'en_US');
INSERT INTO PRODUCT VALUES(46,  'DG-BD-01', 2,
        'Bulldog',                    'DG-BD-01.jpg',
        'Contrary to their intimidating appearance, these dogs love people. They are gentle, dependable with children, known for courage and excellent guardians. They do well as indoor dogs - apartment life and no yard are fine.',
        'en_US');
INSERT INTO PRODUCT VALUES(50,  'DG-DL-01', 2,
        'Dalmatian',                  'DG-DL-01.jpg',
        'Bred to run, this dog has stamina and energy, is playful and sensitive. Enjoys kids, but may be too much for toddlers. Plan to walk or run him often. Very active indoors, best with an average-sized yard.',
        'en_US');
INSERT INTO PRODUCT VALUES(54,  'DG-PW-01', 2,
        'Pembroke Welsh Corgi',       'DG-PW-01.jpg',
        'Hardy, highly intelligent, obedient, and protective, Corgis are devoted little dogs, usually good with kids, and make fine alarm dogs. Very active inside, they do well if exercised and may not need a yard.',
        'en_US');
INSERT INTO PRODUCT VALUES(58,  'DG-BM-01', 2,
        'Bernese Mountain Dog',       'DG-BM-01.jpg',
        'These beautiful tri-color coat dogs are gentle, loyal, smart and easy to train.  They are cheerful dogs that love kids and will become a friend for life. These dogs do best with a large fenced yard and exercise.',
        'en_US');
INSERT INTO PRODUCT VALUES(62,  'DG-GD-01', 2,
        'Great Dane',                 'DG-GD-01.jpg',
        'A gentle giant, this dog is dignified, kind, sweet and affectionate with all ages and loves to be around people. It is a good watchdog. Train well. Will do okay in an apartment, but needs plenty of exercise.',
        'en_US');
INSERT INTO PRODUCT VALUES(66,  'CT-AW-01', 4,
        'American Wirehair',          'CT-AW-01.jpg',
        'Shy and affectionate, this even-tempered cat is a real pussycat! With a sweet face and a spiky coat, this cat is hard to resist. It can be reserved with strangers. They are of medium size and quite muscular.',
        'en_US');
INSERT INTO PRODUCT VALUES(70,  'CT-RD-01', 4,
        'Ragdoll',                    'CT-RD-01.jpg',
        'Pick up one of these amazingly docile cats and it will become as floppy and limp as a ragdoll. These relaxed and tolerant cats, with their luxuriantly long hair, can grow quite large.  The male Ragdoll can reach nearly 20 pounds.',
        'en_US');
INSERT INTO PRODUCT VALUES(74,  'CT-PR-01', 4,
        'Persian',                    'CT-PR-01.jpg',
        'This is a well-mannered, easy-going cat that loves attention. With its medium-to-large build and long-flowing coat, it is a very handsome cat. Gentle and loyal, they enjoy being great companions.',
        'en_US');
INSERT INTO PRODUCT VALUES(78,  'CT-AS-01', 4,
        'American Shorthair',         'CT-AS-01.jpg',
        'With its love of laps and affectionate personality, this is a true family cat. Hardy with a medium-large build, it is a natural hunter. Its claim to fame is the cat that came over on the Mayflower.',
        'en_US');
INSERT INTO PRODUCT VALUES(82,  'CT-SM-01', 4,
        'Siamese',                    'CT-SM-01.jpg',
        'Like poetry in motion this lithe cat will win you over with charm. You will find it to be very intelligent, devoted, and yet mischievous!  The medium size and sleek coat add to it''s characteristics.',
        'en_US');
INSERT INTO PRODUCT VALUES(86,  'BD-FN-01', 5,
        'Finch',                      'BD-FN-01.jpg',
        'The little finch provides lots of entertainment, and has a soft cheerful voice and unique personality. A pleasure to care for, its soft chirping is soothing and pleasant. They are happy in quiet surroundings.',
        'en_US');
INSERT INTO PRODUCT VALUES(88,  'BD-BG-01', 5,
        'Budgerigar',                 'BD-BG-01.jpg',
        'This most popular caged bird in the world is often called a parakeet. The budgie is an excellent pet if treated with love and attention, and is quiet compared to other birds. A few may be taught to speak.',
        'en_US');
INSERT INTO PRODUCT VALUES(90,  'BD-MC-01', 5,
        'Macaw',                      'BD-MC-01.jpg',
        'Macaws are among the largest of parrots.  They are normally very gentle with the people they know well. They can learn to repeat a few words. Like other large parrots, they have a long lifespan.',
        'en_US');
INSERT INTO PRODUCT VALUES(92,  'BD-RL-01', 5,
        'Red-lored Amazon Parrot',    'BD-RC-01.jpg',
        'This beautiful bird is primarily green, with a red forehead, blue crown and yellow cheeks. It is easy to train. They are not known to be great talkers yet they can be very loud, especially in the Spring.',
        'en_US');
INSERT INTO PRODUCT VALUES(94,  'BD-YN-01', 5,
        'Yellow-Naped Amazon Parrot', 'BD-YN-01.jpg',
        'This wonderful parrot is a superb mimic. It has a spicy personality much appreciated by parrot aficionados, and is loving and loyal. The parrot tends to talk more in the morning and evening than during midday.',
        'en_US');
INSERT INTO PRODUCT VALUES(96,  'FS-GF-01', 1,
        'Goldfish',                   'FS-GF-01.jpg',
        'This very popular gold or orange peaceful schooling fish tends to be hardy and long lived, with a life expectancy of 15 to 25 years. They eat a variety of fresh and pelletized food, including live plants.',
        'en_US');
INSERT INTO PRODUCT VALUES(102, 'FS-KO-01', 1,
        'Koi',                        'FS-KO-01.jpg',
        'These powerfully built fish are great in oriental ponds, but like aquarium living until they grow too large. Very good around other fish, and usually found in schools. Feed a variety of food twice a day.',
        'en_US');
INSERT INTO PRODUCT VALUES(108, 'FS-HT-01', 1,
        'Hippo Tang',                 'FS-HT-01.jpg',
        'Easy to keep, fun to watch and called \u201csurgeonfish\u201d because of sharp spines in front of the tailfin. Feed small amounts of live, frozen and prepared formula foods several times a day. Can grow to 12 inches.',
        'en_US');
INSERT INTO PRODUCT VALUES(114, 'FS-ST-01', 1,
        'Yellow Sailfin Tang',        'FS-ST-01.jpg',
        'Bright yellow fins and body are trademarks of this popular, quick darting, fun fish. Sharp tail spines are used for defense and to anchor it in the rocks when asleep. It adds plenty of color to the tank.',
        'en_US');
INSERT INTO PRODUCT VALUES(120, 'FS-CF-01', 1,
        'Clown Fish',                 'FS-CF-01.jpg',
        'A bright fish of varying colors, from yellow to black to blue and bands of white. It is an ideal starter fish, and can grow to 3.5 inches long. Its ungainly swimming action has earned it the name \u201cclownfish.\u201d',
        'en_US');
INSERT INTO PRODUCT VALUES(126, 'RT-CH-01', 3,
        'Chameleon',                  'RT-CH-01.jpg',
        'These reptiles have the ability to change colors in reaction to their surroundings. One of the hardest pets to keep, they need a special cage and a very good diet. They do not like to be held. ',
        'en_US');
INSERT INTO PRODUCT VALUES(130, 'RT-IG-01', 3,
        'Iguana',                     'RT-IG-01.jpg',
        'These green, ferocious-looking beasts need fresh food and water daily, and temperatures of at least 85o. They need large enclosures, including water source and facilities for climbing, such as a greenhouse.',
        'en_US');
INSERT INTO PRODUCT VALUES(134, 'RT-LG-01', 3,
        'Leopard Gecko',              'RT-LG-01.jpg',
        'This wonderfully spotted Gecko is an easy pet. They recognize their keepers and are content to sit on a shoulder. They adapt well to a many environments, but need dry conditions and access to water to drink.',
        'en_US');
INSERT INTO PRODUCT VALUES(138, 'RT-MS-01', 3,
        'Milk Snake',                 'RT-MS-01.jpg',
        'This tri-colored snake with white bands is 50 to 120 cm long. They like to eat mice and are more delicate than others of this species. The babies of these snakes are usually more colorful than the adults.',
        'en_US');
INSERT INTO PRODUCT VALUES(142, 'RT-TR-01', 3,
        'Turtle',                     'RT-TR-01.jpg',
        'Ready for a long-term commitment? Aquatic turtles can live 25 years, and tortoises can outlive humans. They grow 3 to 4 times their original size in only three years! Many have beautifully patterned shells. ',
        'en_US');

CREATE TABLE SHIPPINGMETHOD
       (SHIPPINGOID INTEGER NOT NULL IDENTITY PRIMARY KEY,
        SHIPPINGNAME VARCHAR,
        SHIPPINGDESCRIPTION LONGVARCHAR,
        SHIPPINGPRICE INTEGER,
        SHIPPINGDAYS INTEGER);

INSERT INTO SHIPPINGMETHOD VALUES(1, 'Ground',
        'Prompt, dependable, low-cost ground delivery makes Ground an excellent choice for all your routine shipments. Ground reaches every address throughout the 48 contiguous states.',
        13, 6);
INSERT INTO SHIPPINGMETHOD VALUES(2, '2nd Day Air',
        '2nd Day Air provides guaranteed on-time delivery to every address throughout the United States (excluding intra-Alaska shipments) and Puerto Rico by the end of the second business day. This service is an economical alternative for time-sensitive shipments that do not require overnight or morning service.',
        26, 2);
INSERT INTO SHIPPINGMETHOD VALUES(3, 'Next Day Air',
        'Next Day Air features fast, reliable delivery to every address in all 50 states and Puerto Rico. We guarantee delivery by 10:30 a.m., noon, or end of day the next business day depending on destination (noon or 1:30 p.m. on Saturdays).',
        39, 1);
INSERT INTO SHIPPINGMETHOD VALUES(4, '3 Day Select',
        'The ideal mix of economy and guaranteed on-time delivery, 3 Day Select guarantees delivery within three business days to and from every address in the 48 contiguous states.',
        18, 3);

CREATE TABLE USERINFO
       (USEROID INTEGER NOT NULL PRIMARY KEY,
        FAMILYNAME VARCHAR,
        GIVENNAME VARCHAR,
        PHONE1 VARCHAR,
        PHONE2 VARCHAR,
        EMAIL VARCHAR NOT NULL,
        PASSWORD VARCHAR,
        SHIPPINGOID INTEGER);

CREATE UNIQUE INDEX USERINFO_I1 ON USERINFO(EMAIL);

INSERT INTO USERINFO VALUES(0, 'bbb', 'aaa', '', '',
        'higa@isid.co.jp', 'yasuo', NULL);

CREATE TABLE ZIP
       (CITY VARCHAR,
        STATECODE INTEGER,
        ZIP VARCHAR,
        STATENAME VARCHAR,
        STATE VARCHAR);

CREATE TABLE OIDCOUNTER
       (OIDKEY VARCHAR(20) NOT NULL PRIMARY KEY,
        OIDSEQ INTEGER NOT NULL);

INSERT INTO OIDCOUNTER VALUES('CARTOIDSEQ',       3201);
INSERT INTO OIDCOUNTER VALUES('CREDITCARDOIDSEQ', 2000);
INSERT INTO OIDCOUNTER VALUES('USEROIDSEQ',       2054);

COMMIT;
