/*
class seasar.nazuna.NzRecordSet extends RecordSet
*/
#include "RecordSet.as"
#include "seasar/lang/SObject.as"
if (seasar.nazuna.NzRecordSet === undefined) {
	seasar.lang.SObject.defineClass("seasar.nazuna.NzRecordSet", RecordSet,
		["propertyNames", "rows"],
		function() {	
			this.mTitles = this.propertyNames;
			this.items = this.rows;
			delete this.propertyNames;
			delete this.rows;
		});
	Object.registerClass("org.seasar.nazuna.NzRecordSet", seasar.nazuna.NzRecordSet);
		
	var proto = seasar.nazuna.NzRecordSet.prototype;
		
	proto.toString = function() {
		var count = this.items.length;
		var mes = "";
		for (var i = 0; i < count; ++i) {
			var rec = this.items[i];
			for (var p in rec) {
				var pVal = rec[p];
				var pType = typeof pVal;
				if (pType != "function") {
					mes += p +":"+ pVal + ", ";
				}
			}
			mes = mes.substring(0, mes.length - 2) + "\n";
		}
		return mes;
	}
	
	delete prot;
}